/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.generator;

import de.gerdhirsch.soduko.model.Entry;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.ModelFactory;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SerializableSudoku;
import de.gerdhirsch.soduko.model.SudokuFactory;
import de.gerdhirsch.solver.SudokuSolutionCollector;
import de.gerdhirsch.solver.SudokuSolver;
import java.util.Date;
import java.util.Random;

public class GivensGenerator {
    private int[][] emptyGivens = new int[9][9];
    private Random random = new Random(new Date().getTime());
    private SudokuSolver solver = new SudokuSolver();
    private SudokuSolutionCollector collector = new SudokuSolutionCollector();
    private ModelFactory factory = SudokuFactory.getFactory();
    private SerializableSudoku givenslist = new SerializableSudoku();
    private Game spiel = this.factory.createSpielfeld(this.emptyGivens);
    private int level = 0;

    public GivensGenerator() {
        this(0);
    }

    public GivensGenerator(int level) {
        this.level = level;
    }

    public static void main(String[] args) {
        GivensGenerator gg = new GivensGenerator();
        int[][] givens = gg.generate();
        System.out.println("------- main() -------");
        GivensGenerator.printInts(givens);
        SudokuSolver solver = new SudokuSolver();
        SudokuSolutionCollector collector = new SudokuSolutionCollector();
        solver.solvePuzzle(givens, collector);
        Game spielfeld = SudokuFactory.getFactory().createSpielfeld(givens);
        System.out.println("SolutionCount:" + collector.getSolutionCount());
        for (int[][] solution : collector.getSolutions()) {
            GivensGenerator.printInts(solution);
        }
        GivensGenerator.printVorgabenStatistics(spielfeld);
    }

    public int[][] generate() {
        return this.generate(0);
    }

    public int[][] generate(int level) {
        this.level = level;
        int[][] givens = new int[9][9];
        int[][] solution = null;
        this.clearGivens(givens);
        this.collector.clear();
        do {
            this.createGivensSeed(givens, 25);
            this.solver.solvePuzzle(givens, this.collector);
            if (this.collector.getSolutionCount() != 0) continue;
            this.clearGivens(givens);
        } while (this.collector.getSolutionCount() == 0);
        if (this.collector.getSolutionCount() == 1) {
            solution = this.collector.getSolutions().get(0);
            this.removeGivens(givens, solution);
        } else if (this.collector.getSolutionCount() > 1) {
            solution = this.chooseOneSolution();
            this.collector.clear();
            this.enrich2OneSolution(givens, solution);
        }
        this.addGivens(level, givens, solution);
        return givens;
    }

    private void enrich2OneSolution(int[][] givens, int[][] solution) {
        do {
            this.addGivens(1, givens, solution);
            this.collector.clear();
            this.solver.solvePuzzle(givens, this.collector);
        } while (this.collector.getSolutionCount() > 1);
        this.removeGivens(givens, solution);
    }

    protected void addGivens(int level, int[][] givens, int[][] solution) {
        int z = -1;
        int s = -1;
        int w = 0;
        int count = level;
        while (count > 0) {
            while (true) {
                z = this.random.nextInt(9);
                s = this.random.nextInt(9);
                w = solution[z][s];
                if (this.spiel.getValue(z, s) != 0) continue;
                try {
                    this.spiel.insertValue(z, s, w);
                    this.givenslist.addGiven(z, s, w);
                    givens[z][s] = w;
                }
                catch (RegelverletzungException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
            --count;
        }
    }

    private void removeGivens(int[][] givens, int[][] solution) {
        int zeile = 0;
        int spalte = 0;
        try {
            for (Entry given : this.givenslist.getGivens()) {
                zeile = given.getRow();
                spalte = given.getColumn();
                givens[zeile][spalte] = 0;
                this.spiel.insertValue(zeile, spalte, 0);
                this.collector.clear();
                this.solver.solvePuzzle(givens, this.collector);
                if (this.collector.getSolutionCount() <= 1) continue;
                givens[zeile][spalte] = given.getValue();
                this.spiel.insertValue(zeile, spalte, given.getValue());
            }
        }
        catch (RegelverletzungException e) {
            e.printStackTrace();
        }
    }

    void createGivensSeed(int[][] givens, int count) {
        int givensCount = 0;
        int z = -1;
        int s = -1;
        int w = 0;
        while (givensCount < count) {
            z = this.random.nextInt(9);
            if (!this.spiel.isPossible(z, s = this.random.nextInt(9), w = this.random.nextInt(9) + 1) || this.spiel.getValue(z, s) != 0) continue;
            try {
                this.spiel.insertValue(z, s, w);
                this.givenslist.addGiven(z, s, w);
                givens[z][s] = w;
                ++givensCount;
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }
    }

    void clearGivens(int[][] givens) {
        this.givenslist.getGivens().clear();
        int z = 0;
        while (z < 9) {
            int s = 0;
            while (s < 9) {
                givens[z][s] = 0;
                try {
                    this.spiel.insertValue(z, s, 0);
                }
                catch (RegelverletzungException e) {
                    e.printStackTrace();
                }
                ++s;
            }
            ++z;
        }
    }

    int[][] chooseOneSolution() {
        int solutionNumber = this.random.nextInt(this.collector.getSolutionCount());
        return this.collector.getSolutions().get(solutionNumber);
    }

    static void printInts(int[][] givens) {
        int[][] nArray = givens;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int[] array = nArray[n];
            System.out.println();
            int[] nArray2 = array;
            int n3 = 0;
            int n4 = nArray2.length;
            while (n3 < n4) {
                int g = nArray2[n3];
                System.out.print(" " + g);
                ++n3;
            }
            ++n;
        }
        System.out.println("\n-----------");
    }

    static void printVorgabenStatistics(Game spielfeld) {
        System.out.println("printVorgaben");
        int[] vorgaben = null;
        int[] vorgabenCount = new int[9];
        int givensCount = 0;
        int value = 0;
        int min = 9;
        int row = 0;
        while (row < 9) {
            int column = 0;
            while (column < 9) {
                if (!spielfeld.isGiven(row, column)) {
                    vorgaben = spielfeld.getSuggestions(row, column);
                    value = spielfeld.getValue(row, column);
                    if (vorgaben.length < min) {
                        min = vorgaben.length;
                    }
                    int n = vorgaben.length - 1;
                    vorgabenCount[n] = vorgabenCount[n] + 1;
                    System.out.print(String.valueOf(row) + "/" + column + " Value:" + value + " Count:" + vorgaben.length);
                    int v = 0;
                    while (v < vorgaben.length) {
                        System.out.print(" " + vorgaben[v]);
                        ++v;
                    }
                    System.out.println();
                } else {
                    ++givensCount;
                }
                ++column;
            }
            ++row;
        }
        System.out.println("Min " + min);
        System.out.println("Givens " + givensCount);
        int c = 0;
        while (c < vorgabenCount.length) {
            System.out.print(" " + (c + 1) + ":" + vorgabenCount[c]);
            ++c;
        }
    }
}

