/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.model;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.Group;
import de.gerdhirsch.soduko.model.ModelFactory;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.model.Zelle;
import java.io.Serializable;
import java.util.HashMap;

class GameImpl
implements Game,
Serializable {
    private boolean solved = false;
    private transient HashMap<SudokuListener, SudokuListener> listeners = new HashMap();
    private transient ModelFactory lnkModelFactory = null;
    private Zelle[][] zellen = new Zelle[9][9];
    private Group[] gruppen = new Group[27];
    private int[][] givens = null;
    private int[][] solution = null;

    public GameImpl(ModelFactory factory) {
        this(new int[9][9], factory);
    }

    public GameImpl(int[][] givens, ModelFactory factory) {
        this.givens = givens;
        this.lnkModelFactory = factory;
        int row = 0;
        int column = 0;
        row = 0;
        while (row < 9) {
            column = 0;
            while (column < 9) {
                this.zellen[row][column] = this.lnkModelFactory.createCell(this.givens[row][column]);
                ++column;
            }
            ++row;
        }
        int grpIdx = 0;
        column = 0;
        while (column < this.zellen.length) {
            this.gruppen[grpIdx] = this.lnkModelFactory.createGruppe();
            row = 0;
            while (row < this.zellen[0].length) {
                this.gruppen[grpIdx].add(this.zellen[row][column]);
                ++row;
            }
            ++column;
            ++grpIdx;
        }
        row = 0;
        while (row < this.zellen.length) {
            this.gruppen[grpIdx] = this.lnkModelFactory.createGruppe();
            column = 0;
            while (column < this.zellen[0].length) {
                this.gruppen[grpIdx].add(this.zellen[row][column]);
                ++column;
            }
            ++row;
            ++grpIdx;
        }
        row = 0;
        while (grpIdx < this.gruppen.length) {
            column = 0;
            while (column < this.zellen[0].length) {
                this.gruppen[grpIdx] = this.lnkModelFactory.createGruppe();
                this.initBlocks(row, column, this.gruppen[grpIdx]);
                column += 3;
                ++grpIdx;
            }
            row += 3;
        }
        assert (grpIdx == this.gruppen.length);
        this.initZellen();
    }

    protected void initZellen() {
        Zelle[][] zelleArray = this.zellen;
        int n = 0;
        int n2 = zelleArray.length;
        while (n < n2) {
            Zelle[] array;
            Zelle[] zelleArray2 = array = zelleArray[n];
            int n3 = 0;
            int n4 = zelleArray2.length;
            while (n3 < n4) {
                Zelle z = zelleArray2[n3];
                z.init();
                ++n3;
            }
            ++n;
        }
    }

    private void initBlocks(int row, int column, Group gruppe) {
        int i = 0;
        while (i < 3) {
            int j = 0;
            while (j < 3) {
                gruppe.add(this.zellen[row + i][column + j]);
                ++j;
            }
            ++i;
        }
    }

    public boolean isPossible(int row, int column, int value) {
        return this.zellen[row][column].isPossible(value);
    }

    public boolean isValid(int row, int column) {
        return this.zellen[row][column].isValid();
    }

    public boolean isGiven(int row, int column) {
        return this.zellen[row][column].isGiven();
    }

    public int[][] getGivens() {
        return (int[][])this.givens.clone();
    }

    public boolean isSolved() {
        return this.solved;
    }

    public void insertValue(int row, int column, int value) throws RegelverletzungException {
        int oldValue = this.zellen[row][column].getSymbol();
        this.zellen[row][column].insertValue(value);
        if (oldValue == value) {
            return;
        }
        this.countValidValues(row, column);
    }

    public void insertGiven(int row, int column, int value) throws RegelverletzungException {
        this.zellen[row][column].insertGiven(value);
        this.initZellen();
        this.countValidValues(row, column);
    }

    public void setMemo(int row, int column, int value, boolean set) throws RegelverletzungException {
        this.zellen[row][column].setMemo(value, set);
        this.fireSpielfeldChanged(new SudokuEvent(this, row, column, this.solved));
    }

    public void setFixed(int row, int column, boolean fixed) {
        if (this.zellen[row][column].isFixed() != fixed) {
            this.zellen[row][column].setFixed(fixed);
            this.fireSpielfeldChanged(new SudokuEvent(this, row, column, this.solved));
        }
    }

    public boolean isMemo(int row, int column, int wert) throws RegelverletzungException {
        return this.zellen[row][column].isMemo(wert);
    }

    public int getValue(int row, int column) {
        return this.zellen[row][column].getSymbol();
    }

    public CellQuery getZelle(int row, int column) {
        return this.zellen[row][column];
    }

    public int[] getSuggestions(int row, int column) {
        return this.zellen[row][column].getPossibilities();
    }

    public boolean isFixed(int row, int column) {
        return this.zellen[row][column].isFixed();
    }

    public void addSudokuListener(SudokuListener listener) {
        this.listeners.put(listener, listener);
    }

    public void removeSudokuListener(SudokuListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireSpielfeldChanged(SudokuEvent event) {
        if (this.listeners.values().isEmpty()) {
            return;
        }
        for (SudokuListener l : this.listeners.values()) {
            l.spielfeldChanged(event);
        }
    }

    private void countValidValues(int row, int column) {
        int validValues = 0;
        Zelle[][] zelleArray = this.zellen;
        int n = 0;
        int n2 = zelleArray.length;
        block0: while (n < n2) {
            Zelle[] zeilenArray;
            Zelle[] zelleArray2 = zeilenArray = zelleArray[n];
            int n3 = 0;
            int n4 = zelleArray2.length;
            while (n3 < n4) {
                Zelle z = zelleArray2[n3];
                if (!z.isValid()) break block0;
                ++validValues;
                ++n3;
            }
            ++n;
        }
        this.solved = validValues == this.zellen.length * this.zellen[0].length;
        this.fireSpielfeldChanged(new SudokuEvent(this, row, column, this.solved));
    }
}

