/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.model;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.Entry;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.GameImpl;
import de.gerdhirsch.soduko.model.Group;
import de.gerdhirsch.soduko.model.GroupImpl;
import de.gerdhirsch.soduko.model.ModelFactory;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SerializableSudoku;
import de.gerdhirsch.soduko.model.Solver;
import de.gerdhirsch.soduko.model.Zelle;
import de.gerdhirsch.soduko.model.ZelleImpl;
import de.gerdhirsch.solver.SolverAdapter;
import de.gerdhirsch.solver.SudokuSolver;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;
import de.gerdhirsch.util.undoredo.UndoRedoHandlerImpl;

public class SudokuFactory
implements ModelFactory {
    private static ModelFactory factory = null;

    private SudokuFactory() {
    }

    public Group createGruppe() {
        return new GroupImpl();
    }

    public Zelle createCell(int value) {
        return new ZelleImpl(value);
    }

    public Game createSpielfeld(int[][] vorgaben) {
        return new GameImpl(vorgaben, this);
    }

    public Game createSpielfeld(SerializableSudoku ssudoku) {
        int[][] givens = new int[9][9];
        Game retVal = null;
        for (Entry wert : ssudoku.getGivens()) {
            givens[wert.getRow()][wert.getColumn()] = wert.getValue();
        }
        retVal = this.createSpielfeld(givens);
        for (Entry value : ssudoku.getInputSymbols()) {
            try {
                retVal.insertValue(value.getRow(), value.getColumn(), value.getValue());
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }
        for (Entry value : ssudoku.getFixedSymbols()) {
            try {
                retVal.insertValue(value.getRow(), value.getColumn(), value.getValue());
                retVal.setFixed(value.getRow(), value.getColumn(), true);
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }
        for (Entry value : ssudoku.getMemos()) {
            try {
                retVal.setMemo(value.getRow(), value.getColumn(), value.getValue(), !retVal.isMemo(value.getRow(), value.getColumn(), value.getValue()));
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public SerializableSudoku createSerializable(Game spielfeld) {
        SerializableSudoku retVal = new SerializableSudoku();
        CellQuery cellQuery = null;
        int row = 0;
        while (row < 9) {
            int column = 0;
            while (column < 9) {
                cellQuery = spielfeld.getZelle(row, column);
                if (cellQuery.isGiven()) {
                    retVal.addGiven(row, column, cellQuery.getSymbol());
                } else {
                    if (cellQuery.isFixed()) {
                        retVal.addFixedSymbol(row, column, cellQuery.getSymbol());
                    } else {
                        retVal.addSymbol(row, column, cellQuery.getSymbol());
                    }
                    int i = 1;
                    while (i < 10) {
                        try {
                            if (cellQuery.isMemo(i)) {
                                retVal.addMemo(row, column, i);
                            }
                        }
                        catch (RegelverletzungException e) {
                            e.printStackTrace();
                        }
                        ++i;
                    }
                }
                ++column;
            }
            ++row;
        }
        return retVal;
    }

    public UndoRedoHandler createUndoRedoHandler() {
        return new UndoRedoHandlerImpl();
    }

    public static ModelFactory getFactory() {
        if (factory == null) {
            factory = new SudokuFactory();
        }
        return factory;
    }

    public Solver createSolver() {
        return new SolverAdapter(new SudokuSolver());
    }
}

