/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.model;

import de.gerdhirsch.soduko.model.Group;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.Zelle;

public class ZelleImpl
implements Zelle {
    private int[] vorschlaege = null;
    private boolean[] memos = new boolean[9];
    private int symbol = 0;
    private boolean isGiven = false;
    private int gruppenZaehler = 0;
    private int givensMask = 0;
    private Group[] lnkGruppen = new Group[3];
    private boolean fixed;
    private static short[] masks = new short[10];

    static {
        short ziffer = 1;
        ZelleImpl.masks[0] = 0;
        int i = 1;
        while (i < masks.length) {
            ZelleImpl.masks[i] = ziffer;
            ziffer = (short)(ziffer << 1);
            ++i;
        }
    }

    public ZelleImpl(int given) {
        this.symbol = given;
        this.isGiven = given != 0;
        this.fixed = false;
    }

    public boolean isPossible(int symbol) {
        if (this.isGiven || symbol < 0 || symbol > 9) {
            return false;
        }
        boolean retVal = false;
        retVal = ((this.getMask() ^ masks[symbol]) & masks[symbol]) != 0;
        return retVal;
    }

    public boolean isValid() {
        boolean retVal;
        boolean bl = retVal = this.symbol != 0;
        if (!this.isGiven && retVal) {
            retVal = this.isPossible(this.symbol);
        }
        return retVal;
    }

    public void insertValue(int symbol) throws RegelverletzungException {
        if (this.isGiven) {
            throw new RegelverletzungException("Bei Givens ist keine Eingabe m\u00f6glich!");
        }
        if (symbol < 0 || symbol > 9) {
            throw new RegelverletzungException("Ung\u00fcltiges symbol:" + symbol);
        }
        this.symbol = symbol;
    }

    public void insertGiven(int symbol) throws RegelverletzungException {
        this.isGiven = false;
        this.insertValue(symbol);
        this.isGiven = true;
    }

    public void setMemo(int symbol, boolean set) throws RegelverletzungException {
        if (this.isGiven) {
            throw new RegelverletzungException("Bei Givens ist kein Memo m\u00f6glich!");
        }
        if (symbol < 1 || symbol > 9) {
            throw new RegelverletzungException("Ung\u00fcltiges symbol:" + symbol);
        }
        this.memos[symbol - 1] = set;
    }

    public boolean isMemo(int symbol) throws RegelverletzungException {
        if (symbol < 1 || symbol > 9) {
            throw new RegelverletzungException("Ung\u00fcltiges symbol:" + symbol);
        }
        return this.memos[symbol - 1];
    }

    public int getSymbol() {
        return this.symbol;
    }

    public String toString() {
        if (this.symbol > 0) {
            return "" + this.symbol;
        }
        return "";
    }

    public int getSymbolMask() {
        return masks[this.symbol];
    }

    public int[] getPossibilities() {
        if (this.vorschlaege == null) {
            if (!this.isGiven) {
                int counter = 0;
                int ziffer = 1;
                while (ziffer < masks.length) {
                    if (((this.givensMask ^ masks[ziffer]) & masks[ziffer]) != 0) {
                        ++counter;
                    }
                    ++ziffer;
                }
                this.vorschlaege = new int[counter];
                int i = 0;
                int ziffer2 = 1;
                while (ziffer2 < masks.length) {
                    if (((this.givensMask ^ masks[ziffer2]) & masks[ziffer2]) != 0) {
                        this.vorschlaege[i++] = ziffer2;
                    }
                    ++ziffer2;
                }
            } else {
                this.vorschlaege = new int[1];
            }
        }
        return this.vorschlaege;
    }

    public boolean isGiven() {
        return this.isGiven;
    }

    public int getMask() {
        int temp = this.symbol;
        this.symbol = 0;
        int retVal = 0;
        Group[] groupArray = this.lnkGruppen;
        int n = 0;
        int n2 = groupArray.length;
        while (n < n2) {
            Group g = groupArray[n];
            retVal |= g.getMask();
            ++n;
        }
        this.symbol = temp;
        return retVal;
    }

    public void init() {
        assert (this.gruppenZaehler == 3);
        if (this.symbol == 0) {
            this.isGiven = false;
        }
        this.vorschlaege = null;
        this.givensMask = this.getMask();
    }

    public void setGruppe(Group g) {
        this.lnkGruppen[this.gruppenZaehler++] = g;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    public boolean isFixed() {
        return this.fixed;
    }
}

