/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.test;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SerializableSudoku;
import de.gerdhirsch.soduko.model.SudokuFactory;
import de.gerdhirsch.soduko.test.SpielfeldTestBasis;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SerializeTest
extends SpielfeldTestBasis {
    private SerializableSudoku serializedSudoku = null;
    private Game spielfeldOpened = null;
    private String fileName = "Sudoku";
    private int insertValue = 0;
    private int resultValue = 0;
    private int row = 0;
    private int column = 0;

    private SerializableSudoku load() {
        try {
            FileInputStream fis = new FileInputStream(this.fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            this.serializedSudoku = (SerializableSudoku)ois.readObject();
            this.spielfeldOpened = SudokuFactory.getFactory().createSpielfeld(this.serializedSudoku);
            fis.close();
            ois.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return this.serializedSudoku;
    }

    private void save(SerializableSudoku serSudoku) {
        try {
            FileOutputStream fos = new FileOutputStream(this.fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(SudokuFactory.getFactory().createSerializable(this.spielfeld));
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testSaveAndLoadForOneCell() {
        this.insertValue = 3;
        this.row = 0;
        this.column = 1;
        int[] memos = new int[]{1, 5, 9};
        try {
            this.spielfeld.insertValue(this.row, this.column, this.insertValue);
            int i = 0;
            while (i < memos.length) {
                this.spielfeld.setMemo(this.row, this.column, memos[i], true);
                ++i;
            }
        }
        catch (RegelverletzungException e) {
            e.printStackTrace();
        }
        this.serializedSudoku = SudokuFactory.getFactory().createSerializable(this.spielfeld);
        this.save(this.serializedSudoku);
        this.serializedSudoku = this.load();
        this.spielfeldOpened = SudokuFactory.getFactory().createSpielfeld(this.serializedSudoku);
        this.resultValue = this.spielfeldOpened.getValue(this.row, this.column);
        SerializeTest.assertEquals((int)this.insertValue, (int)this.resultValue);
        int i = 0;
        while (i < memos.length) {
            try {
                SerializeTest.assertTrue((boolean)this.spielfeldOpened.isMemo(this.row, this.column, memos[i]));
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public void testSaveAndLoadForTwoCells() {
        this.insertValue = 3;
        this.row = 2;
        this.column = 0;
        int insertValueSecond = 8;
        int rowNext = 6;
        int columnNext = 8;
        int[] memos = new int[]{2, 4, 6, 8};
        int[] memosSecondCell = new int[]{1, 2, 3, 4, 5, 6};
        try {
            this.spielfeld.insertValue(this.row, this.column, this.insertValue);
            this.spielfeld.insertValue(rowNext, columnNext, insertValueSecond);
            int i = 0;
            while (i < memos.length) {
                this.spielfeld.setMemo(this.row, this.column, memos[i], true);
                ++i;
            }
            i = 0;
            while (i < memosSecondCell.length) {
                this.spielfeld.setMemo(rowNext, columnNext, memosSecondCell[i], true);
                ++i;
            }
        }
        catch (RegelverletzungException e) {
            e.printStackTrace();
        }
        this.serializedSudoku = SudokuFactory.getFactory().createSerializable(this.spielfeld);
        this.save(this.serializedSudoku);
        this.serializedSudoku = this.load();
        this.spielfeldOpened = SudokuFactory.getFactory().createSpielfeld(this.serializedSudoku);
        this.resultValue = this.spielfeldOpened.getValue(this.row, this.column);
        SerializeTest.assertEquals((int)this.insertValue, (int)this.resultValue);
        this.resultValue = this.spielfeldOpened.getValue(rowNext, columnNext);
        SerializeTest.assertEquals((int)insertValueSecond, (int)this.resultValue);
        try {
            int i = 0;
            while (i < memos.length) {
                SerializeTest.assertTrue((boolean)this.spielfeldOpened.isMemo(this.row, this.column, memos[i]));
                ++i;
            }
            i = 0;
            while (i < memosSecondCell.length) {
                SerializeTest.assertTrue((boolean)this.spielfeldOpened.isMemo(rowNext, columnNext, memosSecondCell[i]));
                ++i;
            }
        }
        catch (RegelverletzungException e) {
            e.printStackTrace();
        }
    }
}

