/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.test;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.model.commands.InsertGiven;
import de.gerdhirsch.soduko.test.SpielfeldTestBasis;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;

public class SpielfeldTest
extends SpielfeldTestBasis {
    boolean gameSolved = false;

    public void testImpossiblesGenerator() {
        int[] suggestions = new int[1];
        this.impossiblesGenerator.setSuggestions(suggestions);
        int i = 1;
        while (i < 10) {
            SpielfeldTest.assertTrue((boolean)this.impossiblesGenerator.hasNext());
            SpielfeldTest.assertEquals((int)i, (int)this.impossiblesGenerator.next());
            ++i;
        }
        suggestions = new int[]{1, 3, 5, 9};
        this.impossiblesGenerator.setSuggestions(suggestions);
        int[] expected = new int[]{2, 4, 6, 7, 8};
        int i2 = 0;
        while (i2 < expected.length) {
            SpielfeldTest.assertTrue((boolean)this.impossiblesGenerator.hasNext());
            SpielfeldTest.assertEquals((int)expected[i2], (int)this.impossiblesGenerator.next());
            ++i2;
        }
        suggestions = new int[]{9};
        this.impossiblesGenerator.setSuggestions(suggestions);
        expected = new int[]{1, 2, 3, 4, 5, 6, 7, 8};
        i2 = 0;
        while (i2 < expected.length) {
            SpielfeldTest.assertTrue((boolean)this.impossiblesGenerator.hasNext());
            SpielfeldTest.assertEquals((int)expected[i2], (int)this.impossiblesGenerator.next());
            ++i2;
        }
        suggestions = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
        this.impossiblesGenerator.setSuggestions(suggestions);
        SpielfeldTest.assertFalse((boolean)this.impossiblesGenerator.hasNext());
        SpielfeldTest.assertEquals((int)0, (int)this.impossiblesGenerator.next());
    }

    public void testSuggestions() {
        this._testSuggestions(this.spielfeld);
    }

    public void _testSuggestions(Game spiel) {
        int[] result = null;
        int zeile = 0;
        while (zeile < this.suggestions.length) {
            int spalte = 0;
            while (spalte < this.suggestions[0].length) {
                result = spiel.getSuggestions(zeile, spalte);
                SpielfeldTest.assertEquals((String)("z:" + zeile + " s:" + spalte), (int)this.suggestions[zeile][spalte].length, (int)result.length);
                this.impossiblesGenerator.setSuggestions(this.suggestions[zeile][spalte]);
                while (this.impossiblesGenerator.hasNext()) {
                    int imp = this.impossiblesGenerator.next();
                    SpielfeldTest.assertFalse((String)("z:" + zeile + " s:" + spalte + " i:" + imp), (boolean)spiel.isPossible(zeile, spalte, imp));
                }
                int suggestion = 0;
                while (suggestion < this.suggestions[zeile][spalte].length) {
                    if (this.suggestions[zeile][spalte][suggestion] != 0) {
                        SpielfeldTest.assertTrue((String)("Zeile:" + zeile + " Spalte:" + spalte + "Suggestion:" + suggestion), (boolean)spiel.isPossible(zeile, spalte, this.suggestions[zeile][spalte][suggestion]));
                        SpielfeldTest.assertEquals((String)("Zeile:" + zeile + " Spalte:" + spalte + "Suggestion:" + suggestion), (int)this.suggestions[zeile][spalte][suggestion], (int)result[suggestion]);
                    }
                    ++suggestion;
                }
                ++spalte;
            }
            ++zeile;
        }
    }

    public void testInsertGivenCommand() {
        int[][] emptygivens = new int[9][9];
        UndoRedoHandler urha = this.factory.createUndoRedoHandler();
        Game spiel = this.factory.createSpielfeld(emptygivens);
        InsertGiven c = null;
        int z = 0;
        while (z < 9) {
            int s = 0;
            while (s < 9) {
                if (this.givens[z][s] != 0) {
                    try {
                        c = new InsertGiven(spiel, z, s, spiel.getValue(z, s), this.givens[z][s]);
                        urha.doIt(c);
                        SpielfeldTest.assertTrue((boolean)spiel.isGiven(z, s));
                        SpielfeldTest.assertEquals((int)1, (int)spiel.getSuggestions(z, s).length);
                        SpielfeldTest.assertEquals((int)0, (int)spiel.getSuggestions(z, s)[0]);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++s;
            }
            ++z;
        }
        this._testSuggestions(spiel);
    }

    void printSuggestions(int[] suggestions) {
        System.out.println();
        int[] nArray = suggestions;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int s = nArray[n];
            System.out.print(" " + s);
            ++n;
        }
    }

    public void testGivensSolutionIsPossibleInsert() {
        this.spielfeld.addSudokuListener(new SolvedListener());
        int zeile = 0;
        while (zeile < this.solution.length) {
            int spalte = 0;
            while (spalte < this.solution[0].length) {
                if (this.solution[zeile][spalte] != 0) {
                    SpielfeldTest.assertTrue((boolean)this.spielfeld.isPossible(zeile, spalte, this.solution[zeile][spalte]));
                    SpielfeldTest.assertFalse((boolean)this.spielfeld.isGiven(zeile, spalte));
                    try {
                        this.spielfeld.insertValue(zeile, spalte, this.solution[zeile][spalte]);
                        SpielfeldTest.assertEquals((int)this.solution[zeile][spalte], (int)this.spielfeld.getValue(zeile, spalte));
                        SpielfeldTest.assertTrue((boolean)this.spielfeld.isValid(zeile, spalte));
                        SpielfeldTest.assertTrue((boolean)this.spielfeld.isPossible(zeile, spalte, this.solution[zeile][spalte]));
                        if (zeile > 0) {
                            SpielfeldTest.assertFalse((boolean)this.spielfeld.isPossible(zeile - 1, spalte, this.solution[zeile][spalte]));
                        }
                        if (spalte > 0) {
                            SpielfeldTest.assertFalse((boolean)this.spielfeld.isPossible(zeile, spalte - 1, this.solution[zeile][spalte]));
                        }
                        if (spalte % 3 == 0 && zeile % 3 == 0) {
                            SpielfeldTest.assertFalse((boolean)this.spielfeld.isPossible(zeile + 1, spalte + 1, this.solution[zeile][spalte]));
                        }
                    }
                    catch (RegelverletzungException e) {
                        SpielfeldTest.assertFalse((boolean)true);
                    }
                    try {
                        this.spielfeld.insertValue(zeile, spalte, -1);
                        SpielfeldTest.assertFalse((boolean)true);
                    }
                    catch (RegelverletzungException regelverletzungException) {
                        // empty catch block
                    }
                    try {
                        this.spielfeld.insertValue(zeile, spalte, 10);
                        SpielfeldTest.assertFalse((boolean)true);
                    }
                    catch (RegelverletzungException regelverletzungException) {}
                } else {
                    try {
                        SpielfeldTest.assertFalse((boolean)this.spielfeld.isPossible(zeile, spalte, this.solution[zeile][spalte]));
                        SpielfeldTest.assertTrue((boolean)this.spielfeld.isGiven(zeile, spalte));
                        SpielfeldTest.assertTrue((boolean)this.spielfeld.isValid(zeile, spalte));
                        this.spielfeld.insertValue(zeile, spalte, 1);
                        SpielfeldTest.assertFalse((boolean)true);
                    }
                    catch (RegelverletzungException regelverletzungException) {
                        // empty catch block
                    }
                }
                ++spalte;
            }
            ++zeile;
        }
        SpielfeldTest.assertTrue((boolean)this.spielfeld.isSolved());
        SpielfeldTest.assertTrue((boolean)this.gameSolved);
    }

    class SolvedListener
    implements SudokuListener {
        SolvedListener() {
        }

        public void spielfeldChanged(SudokuEvent event) {
            SpielfeldTest.this.gameSolved = event.isSolved();
        }
    }
}

