/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.test;

import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.model.SudokuSolutionCollector;
import de.gerdhirsch.soduko.model.commands.InsertValue;
import de.gerdhirsch.soduko.test.SpielfeldTestBasis;
import de.gerdhirsch.solver.SudokuSolver;
import de.gerdhirsch.util.undoredo.CommandComposite;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;

public class UndoRedoTest
extends SpielfeldTestBasis {
    boolean gameSolved = false;

    public void testInsertValueCommpositeAndGameSolved() {
        int[][] solvedSolution = (int[][])this.givens.clone();
        this.spielfeld.addSudokuListener(new SolvedListener());
        SudokuSolver sudoku = new SudokuSolver();
        SudokuSolutionCollector collector = new SudokuSolutionCollector();
        sudoku.solvePuzzle(solvedSolution, collector);
        if (collector.getSolutionCount() > 0) {
            solvedSolution = collector.getSolutions().get(0);
        }
        UndoRedoHandler urha = this.factory.createUndoRedoHandler();
        CommandComposite cc = new CommandComposite(this.factory.createUndoRedoHandler());
        try {
            int spalte;
            int zeile = 0;
            while (zeile < solvedSolution.length) {
                spalte = 0;
                while (spalte < solvedSolution[zeile].length) {
                    if (!this.spielfeld.isGiven(zeile, spalte)) {
                        cc.doIt(new InsertValue(this.spielfeld, zeile, spalte, this.spielfeld.getValue(zeile, spalte), solvedSolution[zeile][spalte]));
                    }
                    ++spalte;
                }
                ++zeile;
            }
            urha.doIt(cc);
            UndoRedoTest.assertFalse((boolean)urha.isRedoable());
            UndoRedoTest.assertTrue((boolean)urha.isUndoable());
            UndoRedoTest.assertTrue((boolean)urha.isModified());
            UndoRedoTest.assertTrue((boolean)this.gameSolved);
            UndoRedoTest.assertTrue((boolean)this.spielfeld.isSolved());
            zeile = 0;
            while (zeile < solvedSolution.length) {
                spalte = 0;
                while (spalte < solvedSolution[zeile].length) {
                    UndoRedoTest.assertEquals((int)solvedSolution[zeile][spalte], (int)this.spielfeld.getValue(zeile, spalte));
                    ++spalte;
                }
                ++zeile;
            }
            urha.undo();
            UndoRedoTest.assertTrue((boolean)urha.isRedoable());
            UndoRedoTest.assertFalse((boolean)urha.isUndoable());
            UndoRedoTest.assertFalse((boolean)urha.isModified());
            UndoRedoTest.assertFalse((boolean)this.gameSolved);
            UndoRedoTest.assertFalse((boolean)this.spielfeld.isSolved());
            zeile = 0;
            while (zeile < this.givens.length) {
                spalte = 0;
                while (spalte < this.givens[zeile].length) {
                    UndoRedoTest.assertEquals((int)this.givens[zeile][spalte], (int)this.spielfeld.getValue(zeile, spalte));
                    ++spalte;
                }
                ++zeile;
            }
            urha.redo();
            UndoRedoTest.assertFalse((boolean)urha.isRedoable());
            UndoRedoTest.assertTrue((boolean)urha.isUndoable());
            UndoRedoTest.assertTrue((boolean)urha.isModified());
            UndoRedoTest.assertTrue((boolean)this.gameSolved);
            UndoRedoTest.assertTrue((boolean)this.spielfeld.isSolved());
            zeile = 0;
            while (zeile < solvedSolution.length) {
                spalte = 0;
                while (spalte < solvedSolution[zeile].length) {
                    UndoRedoTest.assertEquals((int)solvedSolution[zeile][spalte], (int)this.spielfeld.getValue(zeile, spalte));
                    ++spalte;
                }
                ++zeile;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testInsertValueCommand() {
        UndoRedoHandler urha = this.factory.createUndoRedoHandler();
        int zeile = 0;
        int spalte = 1;
        int alterWert = this.spielfeld.getValue(zeile, spalte);
        int neuerWert = 1;
        InsertValue c = new InsertValue(this.spielfeld, zeile, spalte, alterWert, neuerWert);
        try {
            urha.doIt(c);
            UndoRedoTest.assertEquals((int)neuerWert, (int)this.spielfeld.getValue(zeile, spalte));
            UndoRedoTest.assertTrue((boolean)urha.isUndoable());
            UndoRedoTest.assertTrue((boolean)urha.isModified());
            UndoRedoTest.assertFalse((boolean)urha.isRedoable());
            urha.undo();
            UndoRedoTest.assertEquals((int)alterWert, (int)this.spielfeld.getValue(zeile, spalte));
            UndoRedoTest.assertFalse((boolean)urha.isUndoable());
            UndoRedoTest.assertFalse((boolean)urha.isModified());
            UndoRedoTest.assertTrue((boolean)urha.isRedoable());
            urha.redo();
            UndoRedoTest.assertEquals((int)neuerWert, (int)this.spielfeld.getValue(zeile, spalte));
            UndoRedoTest.assertTrue((boolean)urha.isUndoable());
            UndoRedoTest.assertTrue((boolean)urha.isModified());
            UndoRedoTest.assertFalse((boolean)urha.isRedoable());
            urha.undo();
            UndoRedoTest.assertEquals((int)alterWert, (int)this.spielfeld.getValue(zeile, spalte));
            UndoRedoTest.assertFalse((boolean)urha.isUndoable());
            UndoRedoTest.assertFalse((boolean)urha.isModified());
            UndoRedoTest.assertTrue((boolean)urha.isRedoable());
            zeile = 1;
            spalte = 2;
            alterWert = this.spielfeld.getValue(zeile, spalte);
            InsertValue c1 = new InsertValue(this.spielfeld, zeile, spalte, alterWert, neuerWert);
            urha.doIt(c1);
            UndoRedoTest.assertEquals((int)neuerWert, (int)this.spielfeld.getValue(zeile, spalte));
            UndoRedoTest.assertTrue((boolean)urha.isUndoable());
            UndoRedoTest.assertTrue((boolean)urha.isModified());
            UndoRedoTest.assertFalse((boolean)urha.isRedoable());
            urha.undo();
            UndoRedoTest.assertEquals((int)alterWert, (int)this.spielfeld.getValue(zeile, spalte));
            UndoRedoTest.assertFalse((boolean)urha.isUndoable());
            UndoRedoTest.assertFalse((boolean)urha.isModified());
            UndoRedoTest.assertTrue((boolean)urha.isRedoable());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class SolvedListener
    implements SudokuListener {
        SolvedListener() {
        }

        public void spielfeldChanged(SudokuEvent event) {
            UndoRedoTest.this.gameSolved = event.isSolved();
        }
    }
}

