/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import java.awt.Color;
import javax.swing.JLayeredPane;
import javax.swing.table.TableCellRenderer;

public abstract class CellRenderer
extends JLayeredPane
implements TableCellRenderer,
OptionsChangeListener,
SodukoConstants {
    protected Color focusBackgroundColor = null;
    protected Color nonFocusBackgroundColor = null;
    protected Color valuesValidForeground = null;
    protected OptionsManager optionsManager;

    public CellRenderer(OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
        optionsManager.addOptionsChangeListener(this);
        this.configureViewCellRenderer(null);
    }

    public void optionsChanged(OptionChangeEvent event) {
        this.configureViewCellRenderer(event);
    }

    private void configureViewCellRenderer(OptionChangeEvent event) {
        Color color;
        if ((event == null || event.isChanged("Focus.Background")) && (color = this.optionsManager.getColor("Focus.Background")) != null) {
            this.focusBackgroundColor = color;
        }
        if ((event == null || event.isChanged("Nonfocus.Background")) && (color = this.optionsManager.getColor("Nonfocus.Background")) != null) {
            this.nonFocusBackgroundColor = color;
        }
        if ((event == null || event.isChanged("Values.Valid.Foreground")) && (color = this.optionsManager.getColor("Values.Valid.Foreground")) != null) {
            this.valuesValidForeground = color;
        }
    }
}

