/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.view.game.GameDecorator;
import java.awt.Toolkit;

public class CheckedGame
extends GameDecorator {
    public CheckedGame(Game game) {
        super(game);
    }

    public void insertValue(int row, int column, int newValue) throws RegelverletzungException {
        if (this.rowColumnOutOfRange(row, column) || newValue < 0 || newValue > 9) {
            Toolkit.getDefaultToolkit().beep();
        } else if (this.game.isGiven(row, column) || this.game.isFixed(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.game.insertValue(row, column, newValue);
        }
    }

    public int getValue(int row, int column) {
        int retVal = -1;
        if (this.rowColumnOutOfRange(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            retVal = this.game.getValue(row, column);
        }
        return retVal;
    }

    public void setMemo(int row, int column, int newValue, boolean set) throws RegelverletzungException {
        try {
            if (this.rowColumnOutOfRange(row, column) || this.game.isGiven(row, column) || newValue <= 0 || newValue > 9) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.game.setMemo(row, column, newValue, set);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isMemo(int row, int column, int symbol) throws RegelverletzungException {
        boolean retVal = false;
        if (this.rowColumnOutOfRange(row, column) || this.game.isGiven(row, column) || symbol <= 0 || symbol > 9) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            try {
                retVal = this.game.isMemo(row, column, symbol);
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    public void setFixed(int row, int column, boolean fixed) {
        try {
            if (this.rowColumnOutOfRange(row, column) || this.game.isGiven(row, column) || this.game.getValue(row, column) == 0) {
                Toolkit.getDefaultToolkit().beep();
            } else {
                this.game.setFixed(row, column, fixed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isFixed(int row, int column) {
        boolean retVal = false;
        if (this.rowColumnOutOfRange(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            retVal = this.game.isFixed(row, column);
        }
        return retVal;
    }

    public int[] getSuggestions(int row, int column) {
        int[] retVal = null;
        if (this.rowColumnOutOfRange(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            retVal = this.game.getSuggestions(row, column);
        }
        if (retVal == null) {
            retVal = new int[1];
        }
        return retVal;
    }

    public boolean isGiven(int row, int column) {
        boolean retVal = false;
        if (this.rowColumnOutOfRange(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            retVal = this.game.isGiven(row, column);
        }
        return retVal;
    }

    public boolean isPossible(int row, int column, int symbol) {
        boolean retVal = false;
        if (this.rowColumnOutOfRange(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            retVal = this.game.isPossible(row, column, symbol);
        }
        return retVal;
    }

    public boolean isValid(int row, int column) {
        boolean retVal = false;
        if (this.rowColumnOutOfRange(row, column)) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            retVal = this.game.isValid(row, column);
        }
        return retVal;
    }

    protected boolean rowColumnOutOfRange(int row, int column) {
        return row < 0 || row >= 9 || column < 0 || column >= 9;
    }
}

