/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;

public class CursorManager
extends MouseAdapter
implements MouseWheelListener {
    private Cursor standardCursor = null;
    private boolean isStandardCursor = false;
    private Cursor[] cursors = null;
    protected int actualCursorIdx = 0;
    private Component component = null;
    private Cursor[] standardCursors = null;
    private boolean isInside = false;
    private String[] cursorSymbols = null;
    private Font symbolFont = null;
    private Color symbolColor = null;

    public CursorManager(Component component, Cursor[] cursors) {
        this(component);
        this.cursors = cursors;
    }

    public CursorManager(Component component) {
        this.component = component;
        this.standardCursor = component.getCursor();
        this.standardCursors = new Cursor[]{new Cursor(1), new Cursor(6), new Cursor(8), new Cursor(7), new Cursor(10), new Cursor(12), new Cursor(11), new Cursor(4), new Cursor(9), new Cursor(5)};
        this.cursors = this.standardCursors;
    }

    public void mouseWheelMoved(MouseWheelEvent event) {
        if (this.isStandardCursor()) {
            this.component.setCursor(this.getActualCursor());
        } else {
            if (event.getWheelRotation() > 0) {
                ++this.actualCursorIdx;
                this.actualCursorIdx %= this.cursors.length;
            } else {
                --this.actualCursorIdx;
                if (this.actualCursorIdx < 0) {
                    this.actualCursorIdx = this.cursors.length - 1;
                }
            }
            this.component.setCursor(this.getActualCursor());
        }
    }

    public Cursor getActualCursor() {
        Cursor retVal = null;
        if (this.isStandardCursor) {
            retVal = this.standardCursor;
        } else if (this.cursors != null) {
            retVal = this.cursors[this.actualCursorIdx];
        }
        return retVal;
    }

    public int getCursorIndex() {
        return this.actualCursorIdx;
    }

    public void mouseEntered(MouseEvent event) {
        this.component.setCursor(this.getActualCursor());
        this.isInside = true;
    }

    public void mouseExited(MouseEvent event) {
        this.component.setCursor(this.standardCursor);
        this.isInside = false;
    }

    public int getCursorCount() {
        if (this.cursors == null) {
            return 0;
        }
        return this.cursors.length;
    }

    public void useStandardCursor(boolean use) {
        this.isStandardCursor = use;
        this.component.setCursor(this.getActualCursor());
    }

    public boolean isStandardCursor() {
        return this.isStandardCursor;
    }

    public void setCursors(Cursor[] cursors) {
        if (this.cursors.length != cursors.length) {
            this.actualCursorIdx = 0;
        }
        this.cursors = cursors;
        this.component.setCursor(this.getActualCursor());
    }

    public boolean isInside() {
        return this.isInside;
    }

    public void setSymbolSet(String[] symbols, Font symbolFont, Color symbolColor) {
        this.cursorSymbols = symbols;
        this.symbolFont = symbolFont;
        this.symbolColor = symbolColor;
        this.createCursorSet();
    }

    private void createCursorSet() {
        Cursor[] cursorSet = new Cursor[this.cursorSymbols.length];
        Point hotspot = new Point(5, 5);
        Toolkit tk = this.component.getToolkit();
        int fontStyle = this.symbolFont.getStyle();
        String fontName = this.symbolFont.getName();
        int fontSize = this.symbolFont.getSize();
        fontSize = fontSize * 100 / 115;
        Font cursorFont = new Font(fontName, fontStyle, fontSize);
        Image cursorImage = null;
        int i = 0;
        while (i < this.cursorSymbols.length) {
            cursorImage = CursorManager.createCursorImage(this.cursorSymbols[i], this.symbolColor, cursorFont);
            cursorSet[i] = tk.createCustomCursor(cursorImage, hotspot, this.cursorSymbols[i]);
            ++i;
        }
        this.setCursors(cursorSet);
    }

    public static Image createCursorImage(String symbol, Color symbolColor, Font cursorFont) {
        int[] xLinePoints = new int[]{12, 8, 5, 5, 15, 10, 14};
        int[] yLinePoints = new int[]{24, 16, 20, 5, 15, 15, 23};
        Color transparentColor = new Color(255, 255, 255, 0);
        int imageSize = 32;
        BufferedImage cursorImage = new BufferedImage(imageSize, imageSize, 2);
        Graphics2D g = cursorImage.createGraphics();
        g.setPaint(transparentColor);
        g.fillRect(0, 0, imageSize, imageSize);
        g.setFont(cursorFont);
        g.setPaint(symbolColor);
        g.drawString(symbol, 17, imageSize);
        g.setPaint(Color.white);
        g.fillPolygon(xLinePoints, yLinePoints, xLinePoints.length);
        g.setPaint(Color.BLACK);
        g.drawPolygon(xLinePoints, yLinePoints, xLinePoints.length);
        g.dispose();
        return cursorImage;
    }
}

