/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game;

import de.gerdhirsch.soduko.generator.GivensGenerator;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.ModelFactory;
import de.gerdhirsch.soduko.model.SerializableSudoku;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuFactory;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.model.SudokuSolutionCollector;
import de.gerdhirsch.soduko.model.commands.InsertValue;
import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.game.CursorManager;
import de.gerdhirsch.soduko.view.game.SudokuView;
import de.gerdhirsch.soduko.view.options.OptionsDialog;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerImpl;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelEvent;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelListener;
import de.gerdhirsch.solver.SudokuSolver;
import de.gerdhirsch.util.jar.BrowserControl;
import de.gerdhirsch.util.jar.JarURLConverter;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import de.gerdhirsch.util.resources.LocalizeManagerImpl;
import de.gerdhirsch.util.resources.ReflexionActionListener;
import de.gerdhirsch.util.undoredo.CommandComposite;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.DefaultDesktopManager;
import javax.swing.ImageIcon;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SodukoGUIApplication
extends JFrame
implements Serializable,
LocalizeListener,
SupportLevelListener,
SodukoConstants,
OptionsChangeListener {
    private SudokuView actualView = null;
    private int lastSudokuXPos = 0;
    private int lastSudokuYPos = 0;
    private JDesktopPane desk = null;
    private InternalFrameAdapter actualViewUpdater = new ActualViewUpdater();
    private ApplicationCloseHandler appCloseListener = new ApplicationCloseHandler();
    private HashMap<SudokuView, SudokuView> views = new HashMap();
    private InternalFrameAdapter closeListener = new WindowCloseListener();
    private OptionsDialog optionsDialog = null;
    private OptionsManager optionsManager = null;
    private ModelFactory factory = SudokuFactory.getFactory();
    private GivensGenerator generator = new GivensGenerator();
    private JFileChooser fileChooser = null;
    private SudokuListener gameListener = new GameListener();
    private LocalizeManager localizeManager = null;
    private JMenuBar menuBar = null;
    private ArrayList<AbstractAction> actions = new ArrayList();
    private ArrayList<JMenuItem> menuItems = new ArrayList();
    private JEditorPane helpAboutMessage = null;
    private static int[][] givens;
    private AbstractAction newLevel1Action = null;
    private AbstractAction newLevel2Action = null;
    private AbstractAction newLevel3Action = null;
    private AbstractAction openAction = null;
    private AbstractAction saveAction = null;
    private AbstractAction undoAction = null;
    private AbstractAction redoAction = null;
    private AbstractAction solveAction = null;
    private ToggleMouseCursor toggleMouseCursorAction = null;
    private AbstractAction pauseAction = null;

    static {
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[9];
        nArray[0] = 4;
        nArray[2] = 3;
        nArray[5] = 8;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[9];
        nArray2[0] = 9;
        nArray2[1] = 2;
        nArray2[6] = 1;
        nArray2[8] = 6;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[9];
        nArray3[5] = 6;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[9];
        nArray4[0] = 5;
        nArray4[2] = 6;
        nArray4[4] = 2;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[9];
        nArray5[1] = 4;
        nArray5[3] = 3;
        nArray5[5] = 1;
        nArray5[7] = 2;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[9];
        nArray6[4] = 7;
        nArray6[6] = 9;
        nArray6[8] = 8;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[9];
        nArray7[3] = 7;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[9];
        nArray8[0] = 3;
        nArray8[2] = 5;
        nArray8[7] = 1;
        nArray8[8] = 2;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[9];
        nArray9[3] = 1;
        nArray9[6] = 5;
        nArray9[8] = 9;
        nArrayArray[8] = nArray9;
        givens = nArrayArray;
    }

    @Override
    public void supportLevelChanged(SupportLevelEvent event) {
        this.checkViewState();
    }

    @Override
    public void optionsChanged(OptionChangeEvent event) {
        String look;
        Locale locale;
        if (event.isChanged("Locale") && (locale = this.optionsManager.getLocale("Locale")) != null) {
            this.localizeManager.setLocale(locale);
        }
        if (event.isChanged("Options.Look.And.Feel") && (look = this.optionsManager.getString("Options.Look.And.Feel")) != null) {
            SwingUtilities.updateComponentTreeUI(this);
        }
        if (event.isChanged("Givens.Foreground") || event.isChanged("Values.Font")) {
            this.toggleMouseCursorAction.configure();
        }
        this.saveOptionsToFile();
    }

    public SudokuView getActualView() {
        return this.actualView;
    }

    public void addChild(JInternalFrame child) {
        child.setLocation(this.lastSudokuXPos, this.lastSudokuYPos);
        this.lastSudokuXPos += 50;
        this.lastSudokuYPos += 50;
        if (this.lastSudokuYPos > 100) {
            this.lastSudokuYPos = 0;
        }
        if (this.lastSudokuXPos > 400) {
            this.lastSudokuXPos = 15;
        }
        this.desk.add(child);
        child.setVisible(true);
    }

    protected void createView(Game game, String title) {
        if (title == null) {
            this.actualView = new SudokuView(game, this.localizeManager, this.optionsManager);
            this.views.put(this.actualView, this.actualView);
        } else {
            this.actualView = new SudokuView(game, title, this.localizeManager, this.optionsManager);
            this.views.put(this.actualView, this.actualView);
        }
        this.actualView.addInternalFrameListener(this.actualViewUpdater);
        this.actualView.getTabSupportLevel().addSupportLevelListener(this);
        game.addSudokuListener(this.gameListener);
        this.actualView.addInternalFrameListener(this.closeListener);
        this.addChild(this.actualView);
    }

    public SodukoGUIApplication(LocalizeManager localizeManager, OptionsManager optionsManager) {
        super(localizeManager.getString("Title"));
        this.localizeManager = localizeManager;
        this.optionsManager = optionsManager;
        this.optionsManager.addOptionsChangeListener(this);
        try {
            String look = optionsManager.getString("Options.Look.And.Feel");
            UIManager.setLookAndFeel(look);
        }
        catch (Exception e) {
            e.printStackTrace();
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        this.fileChooser = new JFileChooser();
        this.createOptionsDialog();
        localizeManager.addLocalizeListener(this);
        this.addWindowListener(this.appCloseListener);
        this.desk = new JDesktopPane();
        this.desk.setDesktopManager(new DefaultDesktopManager());
        this.desk.setOpaque(true);
        this.setContentPane(this.desk);
        this.createMenuAndToolBar();
        URL imgURL = localizeManager.getResource(this, "/de/gerdhirsch/soduko/view/resources/icons/title.gif");
        this.setIconImage(this.createTitleIcon(imgURL));
        this.createView(this.factory.createSpielfeld(givens), localizeManager.getString("SubTitle"));
        this.checkViewState();
        this.setDefaultCloseOperation(0);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SodukoGUIApplication.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        LocalizeManagerImpl lm = new LocalizeManagerImpl("de.gerdhirsch.soduko.view.resources.properties.Resource");
        Locale[] locales = new Locale[]{Locale.GERMANY, Locale.ENGLISH, Locale.FRANCE, new Locale("de", "DE", "BW")};
        lm.setLocales(locales);
        OptionsManager om = SodukoGUIApplication.createOptionsManagerWithDefaults(lm);
        lm.setLocale(om.getLocale("Locale"));
        SodukoGUIApplication soduko = new SodukoGUIApplication(lm, om);
        soduko.setSize(800, 600);
        soduko.setVisible(true);
    }

    protected Image createTitleIcon(URL iconPath) {
        URL imgURL = iconPath;
        if (imgURL != null) {
            return new ImageIcon(imgURL).getImage();
        }
        return null;
    }

    private static OptionsManager createOptionsManagerWithDefaults(LocalizeManager lm) {
        OptionsManager retVal = null;
        retVal = SodukoGUIApplication.loadOptionsFromFile();
        if (retVal == null) {
            HashMap<String, Object> defaults = new HashMap<String, Object>();
            defaults.put("Cell.Dimension", 40);
            defaults.put("Cell.Count", 9);
            defaults.put("Grid.Color", Color.BLACK);
            defaults.put("Focus.Background", Color.WHITE);
            defaults.put("Nonfocus.Background", new Color(230, 230, 230));
            defaults.put("Givens.Font", DEFAULT_FONT);
            defaults.put("Givens.Foreground", Color.BLACK);
            defaults.put("Values.Font", DEFAULT_FONT);
            defaults.put("Values.Valid.Foreground", Color.BLUE);
            defaults.put("Values.Invalid.Foreground", Color.RED);
            defaults.put("Values.Fixed.Foreground", new Color(140, 140, 140));
            defaults.put("Possiblity.Color", Color.BLACK);
            defaults.put("Possiblity.Font", DEFAULT_FONT_SMALL);
            defaults.put("Suggestion.Color", Color.BLACK);
            defaults.put("Suggestion.Font", DEFAULT_FONT_SMALL);
            defaults.put("Symbol.Set", new String[]{"X", "1", "2", "3", "4", "5", "6", "7", "8", "9"});
            defaults.put("Cursor.Style", "Cursor.Selection");
            defaults.put("Locale", lm.getLocale());
            defaults.put("Options.Look.And.Feel", UIManager.getSystemLookAndFeelClassName());
            defaults.put("Default.Supportlevel", 1);
            defaults.put("Max.Supportlevel", 4);
            defaults.put("Soduko.X.Size", 610);
            retVal = new OptionsManagerImpl(defaults);
        }
        return retVal;
    }

    private static String createOptionsFileName() {
        String usrDir = System.getProperty("user.home");
        usrDir = usrDir.replace('/', File.separatorChar);
        String optionsDirName = "/de/gerdhirsch/soduko";
        optionsDirName = optionsDirName.replace('/', File.separatorChar);
        File userOptionsDir = new File(String.valueOf(usrDir) + optionsDirName);
        if (!userOptionsDir.exists() && !userOptionsDir.mkdirs()) {
            optionsDirName = usrDir;
        }
        String optionsFileName = String.valueOf(usrDir) + optionsDirName + File.separatorChar + "Options.opt";
        return optionsFileName;
    }

    private static OptionsManager loadOptionsFromFile() {
        OptionsManager retVal = null;
        String optionsFileName = SodukoGUIApplication.createOptionsFileName();
        File usrOptionsFile = new File(optionsFileName);
        if (usrOptionsFile.exists()) {
            try {
                FileInputStream fis = new FileInputStream(optionsFileName);
                ObjectInputStream ois = new ObjectInputStream(fis);
                retVal = (OptionsManager)ois.readObject();
                fis.close();
                ois.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    private void saveOptionsToFile() {
        String optionsFileName = SodukoGUIApplication.createOptionsFileName();
        try {
            FileOutputStream fos = new FileOutputStream(optionsFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.optionsManager);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createOptionsDialog() {
        LocalizeManager lm = null;
        try {
            lm = (LocalizeManager)this.localizeManager.clone();
            if (this.optionsDialog == null) {
                this.optionsDialog = new OptionsDialog(this.optionsManager, lm, SudokuFactory.getFactory().createUndoRedoHandler());
                this.optionsDialog.setDefaultCloseOperation(1);
                this.optionsDialog.setLocation(360, 120);
                this.optionsDialog.setSize(OPTION_DIALOG_DIMENSION);
            }
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
    }

    private void createMenuAndToolBar() {
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.menuBar.add(this.createFileMenu());
        this.menuBar.add(this.createEditMenu());
        this.menuBar.add(this.createHelpMenu());
        this.menuBar.add(this.createToolBar());
        this.checkViewState();
    }

    private JMenu createFileMenu() {
        String key = null;
        ReflexionActionListener action = null;
        JMenu retVal = null;
        JMenu subMenuNew = null;
        JMenuItem actionMenu = null;
        key = "Menu.File";
        retVal = new JMenu();
        this.menuItems.add(retVal);
        retVal.setActionCommand(key);
        this.localizeMenuItem(retVal);
        key = "Menu.File.New";
        subMenuNew = new JMenu();
        this.menuItems.add(subMenuNew);
        subMenuNew.setActionCommand(key);
        this.localizeMenuItem(subMenuNew);
        retVal.add(subMenuNew);
        key = "Menu.File.New.Level1";
        action = ReflexionActionListener.createAction(this, "newLevel1Action", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.newLevel1Action = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        subMenuNew.add(actionMenu);
        key = "Menu.File.New.Level2";
        action = ReflexionActionListener.createAction(this, "newLevel2Action", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.newLevel2Action = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        subMenuNew.add(actionMenu);
        key = "Menu.File.New.Level3";
        action = ReflexionActionListener.createAction(this, "newLevel3Action", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.newLevel3Action = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        subMenuNew.add(actionMenu);
        retVal.addSeparator();
        key = "Menu.File.Open";
        action = ReflexionActionListener.createAction(this, "openAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.openAction = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        key = "Menu.File.Save";
        action = ReflexionActionListener.createAction(this, "saveAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.saveAction = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        retVal.addSeparator();
        key = "Menu.File.Options";
        action = ReflexionActionListener.createAction(this, "optionsAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        retVal.addSeparator();
        key = "Menu.File.Exit";
        action = ReflexionActionListener.createAction(this, "exitAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        return retVal;
    }

    private JMenu createEditMenu() {
        String key = null;
        AbstractAction action = null;
        JMenuItem actionMenu = null;
        JMenu retVal = null;
        key = "Menu.Edit";
        retVal = new JMenu();
        retVal.setActionCommand(key);
        this.menuItems.add(retVal);
        this.localizeMenuItem(retVal);
        key = "Menu.Edit.Undo";
        action = ReflexionActionListener.createAction(this, "undoAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.undoAction = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        key = "Menu.Edit.Redo";
        action = ReflexionActionListener.createAction(this, "redoAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.redoAction = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        key = "Menu.Edit.Solve";
        action = ReflexionActionListener.createAction(this, "solveAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.solveAction = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        key = "Menu.Edit.Toggle.Cursor";
        action = new ToggleMouseCursor(key);
        this.localizeAction(action);
        this.actions.add(action);
        this.toggleMouseCursorAction = (ToggleMouseCursor)action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        key = "Menu.Edit.Pause";
        action = ReflexionActionListener.createAction(this, "pauseAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.pauseAction = action;
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        return retVal;
    }

    private JMenu createHelpMenu() {
        String key = null;
        ReflexionActionListener action = null;
        JMenuItem actionMenu = null;
        JMenu retVal = null;
        key = "Menu.Help";
        retVal = new JMenu();
        retVal.setActionCommand(key);
        this.menuItems.add(retVal);
        this.localizeMenuItem(retVal);
        key = "Menu.Help.About";
        action = ReflexionActionListener.createAction(this, "aboutAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        key = "Menu.Help.Soduko";
        action = ReflexionActionListener.createAction(this, "helpAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        actionMenu = new JMenuItem(action);
        this.menuItems.add(actionMenu);
        actionMenu.setActionCommand(key);
        this.localizeMenuItem(actionMenu);
        retVal.add(actionMenu);
        return retVal;
    }

    private JToolBar createToolBar() {
        Dimension seperatorDimension = new Dimension(20, 30);
        JToolBar retVal = new JToolBar("SudokuActions");
        retVal.add(this.newLevel1Action);
        retVal.add(this.newLevel2Action);
        retVal.add(this.newLevel3Action);
        retVal.addSeparator(seperatorDimension);
        retVal.add(this.saveAction);
        retVal.add(this.openAction);
        retVal.addSeparator(seperatorDimension);
        retVal.add(this.undoAction);
        retVal.add(this.redoAction);
        retVal.addSeparator(seperatorDimension);
        retVal.add(this.solveAction);
        retVal.addSeparator(seperatorDimension);
        retVal.add(this.toggleMouseCursorAction);
        retVal.add(this.pauseAction);
        return retVal;
    }

    @Override
    public void localeChanged(EventObject event) {
        this.localizeView();
    }

    private void localizeView() {
        this.setTitle(this.localizeManager.getString("Title"));
        this.localizeMenuItems();
        this.localizeActions();
    }

    private void localizeMenuItems() {
        for (JMenuItem menuItem : this.menuItems) {
            this.localizeMenuItem(menuItem);
        }
    }

    private void localizeMenuItem(JMenuItem menuItem) {
        String key = menuItem.getActionCommand();
        HashMap<String, Object> map = this.localizeManager.loadKey(this, key, ";", ":", "&");
        menuItem.setText((String)map.get("Name"));
        Object temp = map.get("MnemonicKey");
        if (temp != null) {
            menuItem.setMnemonic((Integer)temp);
        } else {
            menuItem.setMnemonic(0);
        }
        if (!(menuItem instanceof JMenu)) {
            menuItem.setAccelerator((KeyStroke)map.get("AcceleratorKey"));
        }
        menuItem.setToolTipText((String)map.get("ShortDescription"));
    }

    private void localizeActions() {
        for (AbstractAction action : this.actions) {
            this.localizeAction(action);
        }
    }

    private void localizeAction(AbstractAction action) {
        String key = (String)action.getValue("ResourceKey");
        if (key == null) {
            return;
        }
        HashMap<String, Object> map = this.localizeManager.loadKey(this, key, ";", ":", "&");
        ReflexionActionListener.configureAction(action, map);
    }

    private void checkViewState() {
        if (this.actualView == null) {
            this.disableActions();
            return;
        }
        this.pauseAction.setEnabled(true);
        this.toggleMouseCursorAction.setEnabled(true);
        if (this.actualView.getSupportLevel() == 4 && !this.actualView.getGame().isSolved()) {
            this.solveAction.setEnabled(true);
        } else {
            this.solveAction.setEnabled(false);
        }
        UndoRedoHandler urha = this.actualView.getUndoRedoHandler();
        if (urha.isRedoable()) {
            this.redoAction.setEnabled(true);
        } else {
            this.redoAction.setEnabled(false);
        }
        if (urha.isUndoable()) {
            this.undoAction.setEnabled(true);
        } else {
            this.undoAction.setEnabled(false);
        }
        if (urha.isModified()) {
            this.saveAction.setEnabled(true);
        } else {
            this.saveAction.setEnabled(false);
        }
    }

    private void disableActions() {
        this.saveAction.setEnabled(false);
        this.redoAction.setEnabled(false);
        this.undoAction.setEnabled(false);
        this.solveAction.setEnabled(false);
        this.pauseAction.setEnabled(false);
        this.toggleMouseCursorAction.setEnabled(false);
    }

    private void newLevel1Action(ActionEvent event) {
        String title = (String)this.newLevel1Action.getValue("ShortDescription");
        this.createView(this.factory.createSpielfeld(this.generateGivens(10)), title);
    }

    private void newLevel2Action(ActionEvent event) {
        String title = (String)this.newLevel2Action.getValue("ShortDescription");
        this.createView(this.factory.createSpielfeld(this.generateGivens(5)), title);
    }

    private void newLevel3Action(ActionEvent event) {
        String title = (String)this.newLevel3Action.getValue("ShortDescription");
        this.createView(this.factory.createSpielfeld(this.generateGivens(0)), title);
    }

    private int[][] generateGivens(int givensEnrichment) {
        int[][] retVal = null;
        Cursor oldAppCursor = this.getCursor();
        Cursor oldViewCursor = null;
        Cursor waitCursor = new Cursor(3);
        this.setCursor(waitCursor);
        SudokuView view = this.actualView;
        if (view != null) {
            oldViewCursor = view.getCursor();
            view.setCursor(waitCursor);
        }
        retVal = this.generator.generate(givensEnrichment);
        this.setCursor(oldAppCursor);
        if (view != null) {
            view.setCursor(oldViewCursor);
        }
        return retVal;
    }

    private void openAction(ActionEvent event) {
        JFileChooser fc = new JFileChooser();
        String title = null;
        fc.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".kso");
            }

            public String getDescription() {
                return "Saved Games";
            }
        });
        SerializableSudoku ssudoku = null;
        int retVal = fc.showOpenDialog(fc);
        if (retVal == 0) {
            try {
                File out = fc.getSelectedFile();
                String fileName = out.getPath();
                title = out.getName();
                FileInputStream fis = new FileInputStream(fileName);
                ObjectInputStream ois = new ObjectInputStream(fis);
                ssudoku = (SerializableSudoku)ois.readObject();
                Game sf = SudokuFactory.getFactory().createSpielfeld(ssudoku);
                this.createView(sf, title.substring(0, title.lastIndexOf(46)));
                fis.close();
                ois.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    protected int showSaveDialog(SudokuView view) {
        this.fileChooser.setSelectedFile(new File("./" + view.getTitle()));
        this.fileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith(".kso");
            }

            public String getDescription() {
                return SodukoGUIApplication.this.localizeManager.getString("SavedGames");
            }
        });
        return this.fileChooser.showSaveDialog(this.fileChooser);
    }

    protected void saveSudoku(SudokuView view) {
        try {
            String title = null;
            String fileName = null;
            File out = this.fileChooser.getSelectedFile();
            title = out.getName();
            fileName = out.getPath().endsWith(".kso") ? out.getPath() : String.valueOf(out.getPath()) + ".kso";
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.serializeSudoku(view));
            oos.close();
            fos.close();
            if (title.endsWith(".kso")) {
                title = title.substring(0, title.lastIndexOf(46));
            }
            view.setTitle(title);
            view.getUndoRedoHandler().resetModified();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveAction(ActionEvent event) {
        SudokuView view = this.getActualView();
        int choosenOption = this.showSaveDialog(view);
        if (choosenOption == 0) {
            this.saveSudoku(view);
        }
    }

    private Object serializeSudoku(SudokuView view) {
        Game sf = view.getGame();
        return SudokuFactory.getFactory().createSerializable(sf);
    }

    private void optionsAction(ActionEvent event) {
        if (this.optionsDialog != null) {
            this.optionsDialog.setVisible(true);
        }
    }

    private void exitAction(ActionEvent event) {
        this.appCloseListener.handleCloseWindow();
    }

    private void undoAction(ActionEvent event) {
        try {
            if (this.actualView == null) {
                return;
            }
            this.actualView.getUndoRedoHandler().undo();
            this.checkViewState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void redoAction(ActionEvent event) {
        try {
            if (this.actualView == null) {
                return;
            }
            this.actualView.getUndoRedoHandler().redo();
            this.checkViewState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void solveAction(ActionEvent event) {
        if (this.actualView == null || this.actualView.getGame().isSolved()) {
            return;
        }
        Game spielfeld = this.actualView.getGame();
        int[][] givens = spielfeld.getGivens();
        SudokuSolutionCollector ssc = new SudokuSolutionCollector();
        SudokuSolver ss = new SudokuSolver();
        ss.solvePuzzle(givens, ssc);
        int[][] solvedSolution = ssc.getSolutions().get(0);
        CommandComposite cc = new CommandComposite(this.factory.createUndoRedoHandler());
        try {
            int row = 0;
            while (row < solvedSolution.length) {
                int column = 0;
                while (column < solvedSolution[row].length) {
                    if (!spielfeld.isGiven(row, column)) {
                        cc.doIt(new InsertValue(spielfeld, row, column, spielfeld.getValue(row, column), solvedSolution[row][column]));
                    }
                    ++column;
                }
                ++row;
            }
            this.actualView.getUndoRedoHandler().doIt(cc);
            this.checkViewState();
        }
        catch (Exception e) {
            System.out.println("unerwartete Exception in SodukoGUIApplication");
            e.printStackTrace();
        }
    }

    private void pauseAction(ActionEvent event) {
        SudokuView view = this.getActualView();
        if (view == null) {
            return;
        }
        try {
            view.setIcon(true);
            this.checkViewState();
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
        }
    }

    private void aboutAction(ActionEvent event) {
        URL helpURL = this.localizeManager.getResource(this, "/de/gerdhirsch/soduko/view/resources/AboutHelp.html");
        JScrollPane srcollHelp = null;
        if (helpURL != null) {
            Dimension dim = new Dimension(520, 340);
            this.helpAboutMessage = new JEditorPane();
            this.helpAboutMessage.setEditable(false);
            this.helpAboutMessage.setOpaque(true);
            this.helpAboutMessage.setPreferredSize(dim);
            srcollHelp = new JScrollPane(this.helpAboutMessage);
            try {
                this.helpAboutMessage.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
                e.printStackTrace();
            }
        } else {
            System.err.println("Resource not found: /de/gerdhirsch/soduko/view/resources/AboutHelp.html");
        }
        JOptionPane.showMessageDialog(this, srcollHelp, this.localizeManager.getString("Menu.Help.About.Title"), 1);
    }

    private void helpAction(ActionEvent event) {
        URL helpURL = this.localizeManager.getResource(this, "/de/gerdhirsch/soduko/view/resources/offline/index.html");
        try {
            helpURL = JarURLConverter.getBrowsableURL(helpURL, this);
            BrowserControl.displayURL(helpURL.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected int showExitOptionsDialogOneModified(SudokuView view) {
        String message = String.valueOf(this.localizeManager.getString("WantToSaveBegin")) + " " + view.getTitle() + " " + this.localizeManager.getString("WantToSaveEnd");
        int answer = JOptionPane.showConfirmDialog(this, message, this.localizeManager.getString("ChooseOption"), 1, 3);
        return answer;
    }

    protected int showExitOptionsDialogMoreModified(SudokuView view) {
        Object[] exitDialogButtons = new String[]{this.localizeManager.getString("Yes.Description"), this.localizeManager.getString("No.Description"), this.localizeManager.getString("Cancel.Description"), this.localizeManager.getString("NoForAll.Description")};
        String message = String.valueOf(this.localizeManager.getString("WantToSaveBegin")) + " " + view.getTitle() + " " + this.localizeManager.getString("WantToSaveEnd");
        int answer = JOptionPane.showOptionDialog(this, message, this.localizeManager.getString("ChooseOption"), 0, 3, null, exitDialogButtons, exitDialogButtons[0]);
        return answer;
    }

    protected void viewDispose(SudokuView closingView) {
        closingView.removeInternalFrameListener(this.closeListener);
        this.views.remove(closingView);
        closingView.dispose();
    }

    private Collection<SudokuView> copyModifiedViews() {
        ArrayList<SudokuView> retVal = new ArrayList<SudokuView>();
        Iterator<SudokuView> it = this.views.values().iterator();
        SudokuView view = null;
        while (it.hasNext()) {
            view = it.next();
            if (!view.getUndoRedoHandler().isModified()) continue;
            retVal.add(view);
        }
        return retVal;
    }

    private class GameListener
    implements SudokuListener {
        GameListener() {
        }

        public void spielfeldChanged(SudokuEvent event) {
            SodukoGUIApplication.this.checkViewState();
        }
    }

    private class ToggleMouseCursor
    extends AbstractAction {
        private ImageIcon standardCursorIcon = null;
        private ImageIcon symbolCursorIcon = null;

        public ToggleMouseCursor(String key) {
            this.putValue("ResourceKey", key);
            this.configure();
        }

        public void setEnabled(boolean enable) {
            super.setEnabled(enable);
            this.checkCursor();
        }

        public void putValue(String key, Object value) {
            if (key.equals("SmallIcon")) {
                return;
            }
            super.putValue(key, value);
        }

        public void actionPerformed(ActionEvent event) {
            SudokuView view = SodukoGUIApplication.this.getActualView();
            if (view == null) {
                return;
            }
            if (view.isUseStandardCursor()) {
                view.setUseStandardCursor(false);
            } else {
                view.setUseStandardCursor(true);
            }
            this.checkCursor();
        }

        public void configure() {
            int iconSize = 24;
            Color color = SodukoGUIApplication.this.optionsManager.getColor("Givens.Foreground");
            Font font = SodukoGUIApplication.this.optionsManager.getFont("Values.Font");
            String[] symbolSet = (String[])SodukoGUIApplication.this.optionsManager.getValue("Symbol.Set");
            Image image = CursorManager.createCursorImage("", color, font);
            image = image.getScaledInstance(iconSize, iconSize, 4);
            this.standardCursorIcon = new ImageIcon(image);
            image = CursorManager.createCursorImage(symbolSet[3], color, font);
            image = image.getScaledInstance(iconSize, iconSize, 4);
            this.symbolCursorIcon = new ImageIcon(image);
            this.checkCursor();
        }

        private void checkCursor() {
            SudokuView view = SodukoGUIApplication.this.getActualView();
            if (view != null) {
                if (view.isUseStandardCursor()) {
                    super.putValue("SmallIcon", this.symbolCursorIcon);
                } else {
                    super.putValue("SmallIcon", this.standardCursorIcon);
                }
            } else {
                super.putValue("SmallIcon", this.standardCursorIcon);
            }
        }

        public ImageIcon getSymbolCursorIcon() {
            return this.symbolCursorIcon;
        }
    }

    private class ApplicationCloseHandler
    extends WindowAdapter {
        private static final int FINISHED = 0;
        private static final int ONE_VIEW_MODIFIED = 1;
        private static final int MORE_VIEWS_MODIFIED = 2;
        private static final int SAVE_DIALOG = 3;
        private static final int SAVE_SUDOKU = 4;
        private static final int EXIT = 5;
        private int state = 0;
        private SudokuView closingView = null;
        private Collection<SudokuView> modifiedViews = null;
        private Iterator<SudokuView> modified = null;
        private int modifiedCount = -1;
        private int optionEvent = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !ApplicationCloseHandler.class.desiredAssertionStatus();
        }

        ApplicationCloseHandler() {
        }

        protected void entryAction() {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 5: {
                    System.exit(0);
                    break;
                }
                case 1: {
                    if (this.modified.hasNext()) {
                        this.closingView = this.modified.next();
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    this.optionEvent = SodukoGUIApplication.this.showExitOptionsDialogOneModified(this.closingView);
                    break;
                }
                case 2: {
                    if (this.modified.hasNext()) {
                        this.closingView = this.modified.next();
                    } else if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    this.optionEvent = SodukoGUIApplication.this.showExitOptionsDialogMoreModified(this.closingView);
                    break;
                }
                case 3: {
                    this.optionEvent = SodukoGUIApplication.this.showSaveDialog(this.closingView);
                    break;
                }
                case 4: {
                    SodukoGUIApplication.this.saveSudoku(this.closingView);
                    SodukoGUIApplication.this.viewDispose(this.closingView);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void windowClosing(WindowEvent event) {
            this.handleCloseWindow();
        }

        public void handleCloseWindow() {
            this.modifiedViews = SodukoGUIApplication.this.copyModifiedViews();
            this.modified = this.modifiedViews.iterator();
            this.modifiedCount = this.modifiedViews.size();
            this.state = this.modifiedCount == 1 ? 1 : (this.modifiedCount > 1 ? 2 : 5);
            block21: while (this.state != 0) {
                this.entryAction();
                block0 : switch (this.state) {
                    case 1: {
                        switch (this.optionEvent) {
                            case 0: {
                                this.state = 3;
                                break;
                            }
                            case 1: {
                                this.state = 5;
                                break;
                            }
                            case 2: {
                                this.state = 0;
                            }
                        }
                        continue block21;
                    }
                    case 2: {
                        switch (this.optionEvent) {
                            case 0: {
                                this.state = 3;
                                break block0;
                            }
                            case 1: {
                                --this.modifiedCount;
                                SodukoGUIApplication.this.viewDispose(this.closingView);
                                if (this.modifiedCount == 1) {
                                    this.state = 1;
                                    break block0;
                                }
                                this.state = 2;
                                break block0;
                            }
                            case 2: {
                                this.state = 0;
                                break block0;
                            }
                            case 3: {
                                this.state = 5;
                                break block0;
                            }
                        }
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    case 3: {
                        switch (this.optionEvent) {
                            case 0: {
                                --this.modifiedCount;
                                this.state = 4;
                                break block0;
                            }
                            case 1: {
                                this.state = 0;
                                break block0;
                            }
                        }
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                    case 4: {
                        this.state = this.modifiedCount == 1 ? 1 : (this.modifiedCount > 1 ? 2 : 5);
                    }
                }
            }
        }

        public void windowDeiconified(WindowEvent e) {
            Collection toStart = SodukoGUIApplication.this.views.values();
            for (SudokuView view : toStart) {
                if (view.isIcon()) continue;
                view.startTimer();
            }
        }

        public void windowIconified(WindowEvent e) {
            Collection toStop = SodukoGUIApplication.this.views.values();
            for (SudokuView view : toStop) {
                if (view.isIcon()) continue;
                view.stopTimer();
            }
        }
    }

    private class WindowCloseListener
    extends InternalFrameAdapter {
        private static final int FINISHED = 0;
        private static final int VIEW_MODIFIED = 1;
        private static final int SAVE_DIALOG = 2;
        private static final int DISPOSED = 3;
        private int state = 0;
        private int optionEvent = -1;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            $assertionsDisabled = !WindowCloseListener.class.desiredAssertionStatus();
        }

        WindowCloseListener() {
        }

        protected void entryAction(SudokuView view) {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 3: {
                    SodukoGUIApplication.this.viewDispose(view);
                    this.state = 0;
                    break;
                }
                case 1: {
                    this.optionEvent = SodukoGUIApplication.this.showExitOptionsDialogOneModified(view);
                    break;
                }
                case 2: {
                    this.optionEvent = SodukoGUIApplication.this.showSaveDialog(view);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        public void internalFrameClosing(InternalFrameEvent event) {
            SudokuView view = (SudokuView)event.getSource();
            if (view == null) {
                return;
            }
            this.state = view.getUndoRedoHandler().isModified() ? 1 : 3;
            block13: while (this.state != 0) {
                this.entryAction(view);
                block0 : switch (this.state) {
                    case 1: {
                        switch (this.optionEvent) {
                            case 0: {
                                this.state = 2;
                                break;
                            }
                            case 1: {
                                this.state = 3;
                                break;
                            }
                            case 2: {
                                this.state = 0;
                            }
                        }
                        continue block13;
                    }
                    case 2: {
                        switch (this.optionEvent) {
                            case 0: {
                                SodukoGUIApplication.this.saveSudoku(view);
                                this.state = 3;
                                break block0;
                            }
                            case 1: {
                                this.state = 0;
                                break block0;
                            }
                        }
                        if (!$assertionsDisabled) {
                            throw new AssertionError();
                        }
                        break;
                    }
                }
            }
        }
    }

    private class ActualViewUpdater
    extends InternalFrameAdapter {
        ActualViewUpdater() {
        }

        public void internalFrameClosing(InternalFrameEvent event) {
        }

        public void internalFrameClosed(InternalFrameEvent event) {
            if (SodukoGUIApplication.this.actualView == event.getSource()) {
                SodukoGUIApplication.this.actualView = null;
            }
            SodukoGUIApplication.this.checkViewState();
        }

        public void internalFrameIconified(InternalFrameEvent event) {
            if (SodukoGUIApplication.this.actualView == event.getSource()) {
                SodukoGUIApplication.this.actualView = null;
            }
            SodukoGUIApplication.this.checkViewState();
        }

        public void internalFrameDeiconified(InternalFrameEvent event) {
            SodukoGUIApplication.this.actualView = (SudokuView)event.getSource();
            SodukoGUIApplication.this.checkViewState();
        }

        public void internalFrameActivated(InternalFrameEvent event) {
            SodukoGUIApplication.this.actualView = (SudokuView)event.getSource();
            SodukoGUIApplication.this.checkViewState();
        }

        public void internalFrameDeactivated(InternalFrameEvent event) {
        }
    }
}

