/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.view.ViewCellQuery;
import de.gerdhirsch.soduko.view.game.CellChangeEvent;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRendererListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SodukoTableModel
extends AbstractTableModel
implements SudokuListener,
CellRendererListener {
    private Game game = null;
    private ViewCellQuery[][] cellQueries = null;
    private int lastRow = 0;
    private int lastColumn = 0;
    private static final int SIZE = 9;
    static /* synthetic */ Class class$0;

    private void createViewCellQueries() {
        this.cellQueries = new ViewCellQuery[9][9];
        int row = 0;
        while (row < this.cellQueries.length) {
            int column = 0;
            while (column < this.cellQueries[row].length) {
                ViewCellQueryImpl cellQuery = new ViewCellQueryImpl();
                cellQuery.setCellQuery(this.game.getZelle(row, column));
                this.cellQueries[row][column] = cellQuery;
                ++column;
            }
            ++row;
        }
    }

    public SodukoTableModel(Game game) {
        this.game = game;
        this.game.addSudokuListener(this);
        this.createViewCellQueries();
    }

    @Override
    public int getRowCount() {
        return 9;
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int column) {
        return null;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.cellQueries[row][column];
    }

    @Override
    public void fireTableDataChanged() {
        int row = 0;
        while (row < 9) {
            int column = 0;
            while (column < 9) {
                this.fireTableCellUpdated(row, column);
                ++column;
            }
            ++row;
        }
    }

    @Override
    public void cellChanged(CellChangeEvent event) {
        if (this.lastRow != event.getRow() || this.lastColumn != event.getColumn()) {
            this.cellQueries[this.lastRow][this.lastColumn].setLastSelected(false);
            this.fireTableCellUpdated(this.lastRow, this.lastColumn);
            this.lastRow = event.getRow();
            this.lastColumn = event.getColumn();
            this.cellQueries[this.lastRow][this.lastColumn].setLastSelected(true);
        }
    }

    @Override
    public void spielfeldChanged(SudokuEvent event) {
        this.cellQueries[this.lastRow][this.lastColumn].setLastSelected(false);
        this.lastRow = event.getZeile();
        this.lastColumn = event.getSpalte();
        this.cellQueries[this.lastRow][this.lastColumn].setLastSelected(true);
        this.fireTableDataChanged();
    }

    private class ViewCellQueryImpl
    implements ViewCellQuery {
        private CellQuery selectedCell = null;
        private boolean lastSelected = false;

        ViewCellQueryImpl() {
        }

        public void setCellQuery(CellQuery selectedCell) {
            this.selectedCell = selectedCell;
        }

        public void setLastSelected(boolean lastSelected) {
            this.lastSelected = lastSelected;
        }

        public boolean wasLastSelected() {
            return this.lastSelected;
        }

        public boolean isPossible(int symbol) {
            return this.selectedCell.isPossible(symbol);
        }

        public boolean isValid() {
            return this.selectedCell.isValid();
        }

        public boolean isGiven() {
            return this.selectedCell.isGiven();
        }

        public boolean isMemo(int symbol) throws RegelverletzungException {
            return this.selectedCell.isMemo(symbol);
        }

        public boolean isFixed() {
            return this.selectedCell.isFixed();
        }

        public int getSymbolMask() {
            return this.selectedCell.getSymbolMask();
        }

        public int getMask() {
            return this.selectedCell.getMask();
        }

        public int[] getPossibilities() {
            return this.selectedCell.getPossibilities();
        }

        public int getSymbol() {
            return this.selectedCell.getSymbol();
        }

        public String toString() {
            return this.selectedCell.toString();
        }
    }
}

