/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.ModelFactory;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuFactory;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.view.OptionsPanel;
import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.game.CellChangeEvent;
import de.gerdhirsch.soduko.view.game.CheckedGame;
import de.gerdhirsch.soduko.view.game.CursorManager;
import de.gerdhirsch.soduko.view.game.SodukoTableModel;
import de.gerdhirsch.soduko.view.game.UndoRedoableGame;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer0;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer1;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer2;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRendererListener;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.tabmemo.TabMemo;
import de.gerdhirsch.soduko.view.tabstatistic.TabStatistic;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelEvent;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelListener;
import de.gerdhirsch.soduko.view.tabsupport.TabSupportLevel;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.GregorianCalendar;
import java.util.HashMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SudokuView
extends JInternalFrame
implements Serializable,
SodukoConstants,
LocalizeListener,
SupportLevelListener,
CellRendererListener,
OptionsChangeListener {
    private ModelFactory factory = SudokuFactory.getFactory();
    private Game originGame = null;
    private Game undoRedoableGame = null;
    private Game game = null;
    private OptionsManager optionsManager = null;
    private LocalizeManager localizeManager = null;
    private UndoRedoHandler urha = null;
    private JTabbedPane optionsPanel = null;
    private TabSupportLevel supportLeveltab = null;
    private EditListener editListener = null;
    private TabMemo memoTab = null;
    private boolean useStandardCursor = false;
    private JTable sudokuTable = null;
    private SodukoTableModel tableModel = null;
    private DefaultTableColumnModel columnModelSudoku = null;
    private BlockGridPane blockGridPane = null;
    private JFormattedTextField editor = null;
    private DefaultCellEditor cellEditor;
    private CellRenderer0 level0 = null;
    private CellRenderer0 level1 = null;
    private CellRenderer0 level2 = null;
    private CellRenderer0[] cellRenderer = null;
    private int selectedSodukoRow = 0;
    private int selectedSodukoColumn = 0;
    private JLabel statusBar = null;
    private String actualStatusBarTextKey = null;
    private JLabel startClock = null;
    private JLabel startText = null;
    private JLabel timerLabel = null;
    private JLabel timerText = null;
    private long startTime = 0L;
    private long actualTime = 0L;
    private long duration = 0L;
    private long tempDuration = 0L;
    private boolean timerpause = false;
    private String sessionDauer = "0:00:00";
    private Timer timer = null;
    private SodukoPopupMenuHandler sodukoPopupMenuHandler = null;
    private SodukoMouseListener sodukoMouseListener = null;
    private CursorManager cursorManager = null;

    public SudokuView(Game game, LocalizeManager lm, OptionsManager om) {
        this(game, lm.getString("SubTitle"), lm, om);
    }

    public SudokuView(Game game, String title, LocalizeManager lm, OptionsManager om) {
        super(title, true, true, true, true);
        this.localizeManager = lm;
        this.localizeManager.addLocalizeListener(this);
        this.optionsManager = om;
        this.optionsManager.addOptionsChangeListener(this);
        this.editListener = new EditListener();
        this.sodukoMouseListener = new SodukoMouseListener();
        this.sodukoPopupMenuHandler = new SodukoPopupMenuHandler();
        this.level0 = new CellRenderer0(this.optionsManager);
        this.level1 = new CellRenderer1(this.optionsManager);
        this.level2 = new CellRenderer2(this.optionsManager);
        this.cellRenderer = new CellRenderer0[]{this.level0, this.level1, this.level2, this.level2, this.level2, this.level2, this.level2};
        this.urha = this.factory.createUndoRedoHandler();
        this.originGame = game;
        this.undoRedoableGame = new UndoRedoableGame(game, this.urha);
        this.game = new CheckedGame(this.undoRedoableGame);
        this.game.addSudokuListener(new GameListener());
        Container cp = this.getContentPane();
        cp.setBackground(Color.LIGHT_GRAY);
        if (cp instanceof JComponent) {
            ((JComponent)cp).setOpaque(false);
        }
        JComponent tableView = this.createTableView();
        JComponent optionsPanel = this.createOptionsPanel();
        JSplitPane splitPane = new JSplitPane(1, tableView, optionsPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(380);
        splitPane.setLastDividerLocation(380);
        cp.add(splitPane);
        cp.add((Component)this.createStatusBar(), "South");
        this.setSize(this.optionsManager.getInteger("Soduko.X.Size"), 440);
        this.configureView();
        this.setDefaultCloseOperation(0);
        this.startTime = System.currentTimeMillis();
        this.createTimer();
        this.timer.start();
        this.addComponentListener(new ResizeListener());
        this.addInternalFrameListener(new PauseInternalFrameAdapter());
    }

    public void componentResized(ComponentEvent event) {
    }

    public void stopTimer() {
        this.timerpause = true;
        this.tempDuration = this.duration;
        this.timer.stop();
    }

    public void startTimer() {
        this.startTime = System.currentTimeMillis();
        this.timer.start();
    }

    public Game getGame() {
        return this.originGame;
    }

    public UndoRedoHandler getUndoRedoHandler() {
        return this.urha;
    }

    public TableModel getTableModel() {
        return this.tableModel;
    }

    public TabSupportLevel getTabSupportLevel() {
        return this.supportLeveltab;
    }

    public int getSupportLevel() {
        return this.supportLeveltab.getSupportLevel();
    }

    public void supportLevelChanged(SupportLevelEvent event) {
        int supportLevel = event.getSupportLevel();
        boolean showPossibilityCount = event.isShowPossibilities();
        TableColumn col = null;
        int COUNT = this.columnModelSudoku.getColumnCount();
        this.cellRenderer[supportLevel].setShowPossibilityCount(showPossibilityCount);
        int i = 0;
        while (i < COUNT) {
            col = this.columnModelSudoku.getColumn(i);
            col.setCellRenderer(this.cellRenderer[supportLevel]);
            ++i;
        }
        this.tableModel.fireTableDataChanged();
    }

    public void cellChanged(CellChangeEvent event) {
        this.selectedSodukoRow = event.getRow();
        this.selectedSodukoColumn = event.getColumn();
    }

    protected JComponent createTableView() {
        this.blockGridPane = new BlockGridPane();
        this.createCursorManager(this.blockGridPane);
        JComponent table = this.createTable();
        JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add((Component)table, JLayeredPane.DEFAULT_LAYER);
        int tableDimension = table.getWidth() * table.getHeight();
        this.blockGridPane.setBounds(10, 10, tableDimension, tableDimension);
        this.blockGridPane.setOpaque(false);
        layeredPane.add((Component)this.blockGridPane, JLayeredPane.PALETTE_LAYER);
        return layeredPane;
    }

    protected void createCursorManager(Component c) {
        if (this.cursorManager != null) {
            return;
        }
        Color givensColor = this.optionsManager.getColor("Givens.Foreground");
        Font validFont = this.optionsManager.getFont("Values.Font");
        String[] symbolSet = (String[])this.optionsManager.getValue("Symbol.Set");
        this.cursorManager = new CursorManager(c);
        this.cursorManager.setSymbolSet(symbolSet, validFont, givensColor);
        if (this.optionsManager.getString("Cursor.Style").equals("Symbol.Set")) {
            this.setUseStandardCursor(false);
        } else {
            this.setUseStandardCursor(true);
        }
    }

    protected JComponent createTable() {
        this.editor = new JFormattedTextField();
        this.editor.setFont(DEFAULT_FONT);
        this.cellEditor = new DefaultCellEditor(this.editor);
        int defaultSupportLevel = this.optionsManager.getInteger("Default.Supportlevel");
        int cellDimension = this.optionsManager.getInteger("Cell.Dimension");
        int cellCount = this.optionsManager.getInteger("Cell.Count");
        this.columnModelSudoku = new DefaultTableColumnModel();
        int i = 0;
        while (i < cellCount) {
            TableColumn col = new TableColumn(i, cellDimension);
            col.setCellRenderer(this.cellRenderer[defaultSupportLevel]);
            col.setCellEditor(this.cellEditor);
            this.columnModelSudoku.addColumn(col);
            ++i;
        }
        this.tableModel = new SodukoTableModel(this.game);
        this.sudokuTable = new JTable(this.tableModel, this.columnModelSudoku);
        this.sudokuTable.addKeyListener(this.editListener);
        this.sudokuTable.setBackground(this.optionsManager.getColor("Nonfocus.Background"));
        this.sudokuTable.setRowHeight(cellDimension);
        this.sudokuTable.setGridColor(this.optionsManager.getColor("Grid.Color"));
        this.sudokuTable.setAutoResizeMode(0);
        this.sudokuTable.addMouseListener(this.cursorManager);
        this.sudokuTable.addMouseWheelListener(this.cursorManager);
        this.sudokuTable.addMouseListener(this.sodukoMouseListener);
        this.sudokuTable.addMouseListener(this.sodukoPopupMenuHandler);
        int tableDimension = cellDimension * cellCount;
        this.sudokuTable.setBounds(10, 10, tableDimension, tableDimension);
        return this.sudokuTable;
    }

    protected JComponent createOptionsPanel() {
        this.optionsPanel = new JTabbedPane();
        TabStatistic tabStatistic = new TabStatistic(this.game, this.localizeManager);
        this.memoTab = new TabMemo(this.game, this.localizeManager, this.optionsManager);
        CellRenderer0[] cellRenderer0Array = this.cellRenderer;
        int n = 0;
        int n2 = cellRenderer0Array.length;
        while (n < n2) {
            CellRenderer0 scr = cellRenderer0Array[n];
            scr.addCellRendererListener(this.tableModel);
            scr.addCellRendererListener(this);
            scr.addCellRendererListener(this.memoTab);
            ++n;
        }
        this.supportLeveltab = new TabSupportLevel(this.localizeManager, this.optionsManager);
        this.supportLeveltab.addSupportLevelListener(this);
        this.supportLeveltab.addSupportLevelListener(this.memoTab);
        this.optionsPanel.addTab("Inf", this.memoTab);
        this.optionsPanel.addTab("Sup", this.supportLeveltab);
        this.optionsPanel.addTab("Stat", tabStatistic);
        this.localizeOptionsPanel();
        return this.optionsPanel;
    }

    protected JComponent createStatusBar() {
        JPanel statusPanel = new JPanel();
        this.actualStatusBarTextKey = "SudokuView.StatusText.Play";
        this.statusBar = new JLabel("      " + this.localizeManager.getString(this.actualStatusBarTextKey));
        this.startText = new JLabel(this.localizeManager.getString("SodukoView.Starttime.Text"));
        this.startClock = new JLabel(this.editLabel(this.getTime(), 3));
        this.timerText = new JLabel("    " + this.localizeManager.getString("SodukoView.Timer.Text"));
        this.timerLabel = new JLabel(this.editLabel(this.sessionDauer, 3));
        statusPanel.add(this.startText);
        statusPanel.add(this.startClock);
        statusPanel.add(this.timerText);
        statusPanel.add(this.timerLabel);
        statusPanel.add(this.statusBar);
        return statusPanel;
    }

    public void localeChanged(EventObject event) {
        this.localizeView();
    }

    protected void localizeView() {
        this.statusBar.setText("      " + this.localizeManager.getString(this.actualStatusBarTextKey));
        this.startText.setText(this.localizeManager.getString("SodukoView.Starttime.Text"));
        this.timerText.setText("    " + this.localizeManager.getString("SodukoView.Timer.Text"));
        this.localizeOptionsPanel();
    }

    protected void localizeOptionsPanel() {
        int COMPONENTCOUNT = this.optionsPanel.getComponentCount();
        OptionsPanel panel = null;
        String key = null;
        HashMap<String, Object> map = null;
        int i = 0;
        while (i < COMPONENTCOUNT) {
            panel = (OptionsPanel)this.optionsPanel.getComponent(i);
            key = panel.getResourceKey();
            map = this.localizeManager.loadKey(this, key, ";", ":", "&");
            this.localizeOptionsPanel(i, (String)map.get("Name"), (Icon)map.get("SmallIcon"), (Integer)map.get("MnemonicKey"), (String)map.get("ShortDescription"), (String)map.get("LongDescription"));
            ++i;
        }
    }

    protected void localizeOptionsPanel(int pos, String name, Icon icon, Integer mnemonic, String shortDescription, String longDescription) {
        this.optionsPanel.setTitleAt(pos, name);
        this.optionsPanel.setMnemonicAt(pos, mnemonic);
        this.optionsPanel.setToolTipTextAt(pos, shortDescription);
        this.optionsPanel.setIconAt(pos, icon);
    }

    private void showCongratulationDialog(String message) {
        JOptionPane.showInternalMessageDialog(this, message, this.getTitle(), 1);
    }

    public void optionsChanged(OptionChangeEvent event) {
        this.configureView(event);
        this.configureCursor(event);
    }

    protected void configureView() {
        this.configureView(null);
    }

    protected void configureView(OptionChangeEvent event) {
        Color color;
        if ((event == null || event.isChanged("Nonfocus.Background")) && (color = this.optionsManager.getColor("Nonfocus.Background")) != null) {
            this.sudokuTable.setBackground(color);
        }
        if ((event == null || event.isChanged("Grid.Color")) && (color = this.optionsManager.getColor("Grid.Color")) != null) {
            this.blockGridPane.setGridColor(this.optionsManager.getColor("Grid.Color"));
            this.sudokuTable.setGridColor(this.optionsManager.getColor("Grid.Color"));
        }
        this.tableModel.fireTableDataChanged();
    }

    public void setUseStandardCursor(boolean useStandardCursor) {
        this.useStandardCursor = useStandardCursor;
        this.cursorManager.useStandardCursor(useStandardCursor);
    }

    public boolean isUseStandardCursor() {
        return this.useStandardCursor;
    }

    protected void configureCursor(OptionChangeEvent event) {
        if (event == null || event.isChanged("Givens.Foreground") || event.isChanged("Values.Font") || event.isChanged("Symbol.Set")) {
            Color givensColor = this.optionsManager.getColor("Givens.Foreground");
            Font validFont = this.optionsManager.getFont("Values.Font");
            String[] symbolSet = (String[])this.optionsManager.getValue("Symbol.Set");
            this.cursorManager.setSymbolSet(symbolSet, validFont, givensColor);
        }
        if (event == null || event.isChanged("Cursor.Style")) {
            this.useStandardCursor = !this.optionsManager.getString("Cursor.Style").equals("Symbol.Set");
            this.cursorManager.useStandardCursor(this.useStandardCursor);
        }
    }

    private void createTimer() {
        this.timer = new Timer(1000, new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                SudokuView.this.berechneDauer();
                SudokuView.this.timerLabel.setText(SudokuView.this.editLabel(SudokuView.this.sessionDauer, 3));
            }
        });
    }

    private void berechneDauer() {
        this.actualTime = System.currentTimeMillis();
        this.duration = (this.actualTime - this.startTime) / 1000L;
        if (this.timerpause) {
            this.duration += this.tempDuration;
        }
        this.sessionDauer = this.zeitFormat(this.duration);
    }

    private String editLabel(String text, int size) {
        String htmlString = "<html><font size=" + size + " color=black><b>" + text + "</b></font></html>";
        return htmlString;
    }

    private String getTime() {
        String minute = null;
        GregorianCalendar calendar = new GregorianCalendar();
        int hour = calendar.get(11);
        int min = calendar.get(12);
        minute = "" + min;
        if (min < 10) {
            minute = "0" + min;
        }
        return String.valueOf(hour) + ":" + minute;
    }

    private String zeitFormat(long dauer) {
        String sekunden = "" + dauer % 60L;
        String minuten = "" + dauer % 3600L / 60L;
        String stunden = "" + dauer / 3600L;
        if (dauer % 60L < 10L) {
            sekunden = "0" + sekunden;
        }
        if (dauer % 3600L / 60L < 10L) {
            minuten = "0" + minuten;
        }
        String gesamt = String.valueOf(stunden) + ":" + minuten + ":" + sekunden;
        return gesamt;
    }

    private class ResizeListener
    extends ComponentAdapter {
        ResizeListener() {
        }

        public void componentResized(ComponentEvent event) {
            SudokuView.this.componentResized(event);
        }
    }

    public class PauseInternalFrameAdapter
    extends InternalFrameAdapter {
        public void internalFrameIconified(InternalFrameEvent event) {
            SudokuView.this.stopTimer();
        }

        public void internalFrameDeiconified(InternalFrameEvent event) {
            SudokuView.this.startTimer();
        }
    }

    private class SodukoPopupMenuHandler
    extends MouseAdapter
    implements ActionListener {
        String[] symbolSet;
        JPopupMenu popupMenu;
        private int row;
        private int column;

        public SodukoPopupMenuHandler() {
            this.symbolSet = (String[])SudokuView.this.optionsManager.getValue("Symbol.Set");
            this.popupMenu = new JPopupMenu();
            this.createPopupMenu();
        }

        protected void createPopupMenu() {
            JMenuItem menuItem = null;
            String symbol = null;
            int i = 0;
            while (i < this.symbolSet.length) {
                symbol = this.symbolSet[i];
                menuItem = new JMenuItem(symbol);
                menuItem.addActionListener(this);
                menuItem.setActionCommand("" + i);
                menuItem.setToolTipText("Symbol einf\u00fcgen, +Ctrl Memo setzen/l\u00f6schen");
                this.popupMenu.add(menuItem);
                ++i;
            }
            ((JMenuItem)this.popupMenu.getComponent(0)).setToolTipText("L\u00f6schen");
        }

        public void actionPerformed(ActionEvent event) {
            JMenuItem menuItem = (JMenuItem)event.getSource();
            Integer symbolIndex = Integer.parseInt(event.getActionCommand());
            int mods = event.getModifiers();
            try {
                if ((mods & 2) != 0) {
                    boolean memo = SudokuView.this.game.isMemo(this.row, this.column, symbolIndex);
                    SudokuView.this.game.setMemo(this.row, this.column, symbolIndex, !memo);
                } else {
                    SudokuView.this.game.insertValue(this.row, this.column, symbolIndex);
                }
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }

        protected void selectCellAndShowPopup(MouseEvent event) {
            if (!event.isPopupTrigger()) {
                return;
            }
            this.row = SudokuView.this.sudokuTable.rowAtPoint(event.getPoint());
            this.column = SudokuView.this.sudokuTable.columnAtPoint(event.getPoint());
            int xPos = event.getX();
            int yPos = event.getY();
            System.out.println("PopupTrigger row/column: " + this.row + "/" + this.column + " xPos/yPos:" + xPos + "/" + yPos);
            if (SudokuView.this.cursorManager.isStandardCursor() && !SudokuView.this.game.isGiven(this.row, this.column)) {
                SudokuView.this.sudokuTable.setRowSelectionInterval(this.row, this.row);
                SudokuView.this.sudokuTable.setColumnSelectionInterval(this.column, this.column);
                this.popupMenu.show(SudokuView.this.sudokuTable, xPos, yPos -= this.symbolSet.length * 10);
            }
        }

        public void mousePressed(MouseEvent event) {
            this.selectCellAndShowPopup(event);
        }

        public void mouseReleased(MouseEvent event) {
            this.selectCellAndShowPopup(event);
        }
    }

    private class SodukoMouseListener
    extends MouseAdapter {
        private int cellCount;

        SodukoMouseListener() {
            this.cellCount = SudokuView.this.optionsManager.getInteger("Cell.Count");
        }

        public void mouseClicked(MouseEvent event) {
            int row = SudokuView.this.sudokuTable.rowAtPoint(event.getPoint());
            int column = SudokuView.this.sudokuTable.columnAtPoint(event.getPoint());
            int value = -1;
            if (event.getButton() == 1 && event.isAltDown() && event.isControlDown()) {
                SudokuView.this.memoTab.toggleFixed();
            }
            if (SudokuView.this.cursorManager.isStandardCursor()) {
                return;
            }
            try {
                if (event.isAltDown() && !event.isControlDown()) {
                    return;
                }
                if (event.getButton() == 1) {
                    value = SudokuView.this.cursorManager.getCursorIndex();
                    if (event.isControlDown() && !event.isAltDown()) {
                        SudokuView.this.game.setMemo(row, column, value, !SudokuView.this.game.isMemo(row, column, value));
                    } else if (!event.isAltDown() && !event.isControlDown()) {
                        if (value == SudokuView.this.game.getValue(row, column)) {
                            SudokuView.this.game.insertValue(row, column, 0);
                        } else {
                            SudokuView.this.game.insertValue(row, column, value);
                        }
                    }
                }
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }

        public void mouseEntered(MouseEvent event) {
            SudokuView.this.cursorManager.useStandardCursor(SudokuView.this.useStandardCursor);
            SudokuView.this.sudokuTable.requestFocusInWindow();
        }
    }

    private class EditListener
    extends KeyAdapter {
        final int FIXED = 6;
        final int REDO = 25;
        final int UNDO = 26;
        final int BACKSPACE = 8;
        final int BLANK = 32;
        final int DELETE = 127;
        boolean tempStandardCursor = false;

        EditListener() {
        }

        public void keyPressed(KeyEvent event) {
            int value = event.getKeyChar();
            if (event.isAltDown() && SudokuView.this.cursorManager.isInside()) {
                SudokuView.this.cursorManager.useStandardCursor(true);
                this.tempStandardCursor = true;
            } else if (event.isControlDown()) {
                try {
                    if (value >= 48 && value <= 57) {
                        boolean setMemo = !SudokuView.this.game.isMemo(SudokuView.this.selectedSodukoRow, SudokuView.this.selectedSodukoColumn, value -= 48);
                        SudokuView.this.game.setMemo(SudokuView.this.selectedSodukoRow, SudokuView.this.selectedSodukoColumn, value, setMemo);
                    } else if (value == 6) {
                        SudokuView.this.memoTab.toggleFixed();
                    }
                }
                catch (RegelverletzungException e) {
                    e.printStackTrace();
                }
            } else if (!event.isControlDown()) {
                try {
                    if (value >= 48 && value <= 57) {
                        SudokuView.this.game.insertValue(SudokuView.this.selectedSodukoRow, SudokuView.this.selectedSodukoColumn, value -= 48);
                    } else if (value == 8 || value == 127 || value == 32) {
                        SudokuView.this.game.insertValue(SudokuView.this.selectedSodukoRow, SudokuView.this.selectedSodukoColumn, 0);
                    }
                }
                catch (RegelverletzungException e) {
                    e.printStackTrace();
                }
            }
        }

        public void keyReleased(KeyEvent event) {
            char value = event.getKeyChar();
            if (this.tempStandardCursor && SudokuView.this.cursorManager.isInside()) {
                SudokuView.this.cursorManager.useStandardCursor(SudokuView.this.useStandardCursor);
            }
            if (value == '\u001a' || value == '\u0019') {
                SudokuView.this.cellEditor.cancelCellEditing();
            } else {
                SudokuView.this.cellEditor.stopCellEditing();
            }
        }
    }

    private class BlockGridPane
    extends JPanel {
        private Color gridColor = null;

        BlockGridPane() {
        }

        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int xPos = 1;
            int yPos = 1;
            int cellDimension = SudokuView.this.optionsManager.getInteger("Cell.Dimension");
            g.setColor(this.gridColor);
            int xBox = 0;
            while (xBox < 3) {
                int yBox = 0;
                while (yBox < 3) {
                    xPos = 0 + xBox * cellDimension * 3;
                    yPos = 0 + yBox * cellDimension * 3;
                    g.drawRect(xPos, yPos, 3 * cellDimension - 1, 3 * cellDimension - 1);
                    ++yBox;
                }
                ++xBox;
            }
        }

        public Color getGridColor() {
            return this.gridColor;
        }

        public void setGridColor(Color gridColor) {
            this.gridColor = gridColor;
        }
    }

    private class GameListener
    implements SudokuListener {
        GameListener() {
        }

        public void spielfeldChanged(SudokuEvent event) {
            if (event.isSolved()) {
                SudokuView.this.actualStatusBarTextKey = "SudokuView.StatusText.Finish";
                String statusText = SudokuView.this.localizeManager.getString(SudokuView.this.actualStatusBarTextKey);
                SudokuView.this.statusBar.setText(statusText);
                SudokuView.this.timer.stop();
                SudokuView.this.showCongratulationDialog(statusText);
            } else {
                SudokuView.this.actualStatusBarTextKey = "SudokuView.StatusText.Play";
                SudokuView.this.statusBar.setText(SudokuView.this.localizeManager.getString(SudokuView.this.actualStatusBarTextKey));
                int row = event.getZeile();
                int column = event.getSpalte();
                SudokuView.this.sudokuTable.setRowSelectionInterval(row, row);
                SudokuView.this.sudokuTable.setColumnSelectionInterval(column, column);
            }
        }
    }
}

