/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.commands.InsertGiven;
import de.gerdhirsch.soduko.model.commands.InsertValue;
import de.gerdhirsch.soduko.model.commands.SetFixed;
import de.gerdhirsch.soduko.model.commands.SetMemo;
import de.gerdhirsch.soduko.view.game.GameDecorator;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;

public class UndoRedoableGame
extends GameDecorator {
    private UndoRedoHandler urha = null;

    public UndoRedoableGame(Game game, UndoRedoHandler urha) {
        super(game);
        this.urha = urha;
    }

    public void insertValue(int row, int column, int newValue) throws RegelverletzungException {
        int oldValue = this.game.getValue(row, column);
        if (oldValue != newValue) {
            InsertValue command = new InsertValue(this.game, row, column, oldValue, newValue);
            try {
                this.urha.doIt(command);
            }
            catch (Exception e) {
                if (e instanceof RegelverletzungException) {
                    throw (RegelverletzungException)e;
                }
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                e.printStackTrace();
            }
        }
    }

    public void insertGiven(int row, int column, int newValue) throws RegelverletzungException {
        int oldValue = this.game.getValue(row, column);
        InsertGiven command = new InsertGiven(this.game, row, column, oldValue, newValue);
        try {
            this.urha.doIt(command);
        }
        catch (Exception e) {
            if (e instanceof RegelverletzungException) {
                throw (RegelverletzungException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            e.printStackTrace();
        }
    }

    public void setMemo(int row, int column, int value, boolean set) throws RegelverletzungException {
        try {
            SetMemo setMemo = new SetMemo(this.game, row, column, value, set);
            this.urha.doIt(setMemo);
        }
        catch (Exception e) {
            if (e instanceof RegelverletzungException) {
                throw (RegelverletzungException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            e.printStackTrace();
        }
    }

    public void setFixed(int row, int column, boolean fixed) {
        try {
            SetFixed setFixed = new SetFixed(this.game, row, column, fixed);
            this.urha.doIt(setFixed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

