/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game.cellrenderer;

import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.view.CellRenderer;
import de.gerdhirsch.soduko.view.ViewCellQuery;
import de.gerdhirsch.soduko.view.game.CellChangeEvent;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRendererListener;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.tabmemo.MemoLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JTable;

public class CellRenderer0
extends CellRenderer {
    protected Font givensFont = null;
    protected Color givensForegroundColor = null;
    protected Font valuesFont = null;
    protected Color valuesFixedForeground = null;
    protected Font memosFont = null;
    protected boolean showPossibilityCount = false;
    protected boolean paintInFocusColor = false;
    private CellChangeEvent event = new CellChangeEvent(this);
    protected JLabel value = null;
    protected MemoLabel[] memoLabels = null;
    private HashMap<CellRendererListener, CellRendererListener> listeners = null;
    private int xPos = 6;
    private int yPos = 3;
    private int width = 35;
    private int height = 35;

    public CellRenderer0(OptionsManager optionsManager) {
        super(optionsManager);
        this.add((Component)this.createValue(), JLayeredPane.PALETTE_LAYER);
        this.createMemoLabels();
        this.configureViewCellRenderer0(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object cell, boolean isSelected, boolean hasFocus, int row, int column) {
        if (cell instanceof String) {
            this.value.setText((String)cell);
            return this;
        }
        ViewCellQuery zellquery = (ViewCellQuery)cell;
        boolean bl = this.paintInFocusColor = hasFocus || zellquery.wasLastSelected();
        if (this.paintInFocusColor) {
            this.setOpaque(true);
            this.setBackground(this.focusBackgroundColor);
            this.event.setZelle(zellquery);
            this.event.setRow(row);
            this.event.setColumn(column);
            if (hasFocus) {
                this.fireCellChanged(this.event);
            }
        } else {
            this.setBackground(this.nonFocusBackgroundColor);
        }
        if (zellquery.isGiven()) {
            this.value.setFont(this.givensFont);
            this.value.setForeground(this.givensForegroundColor);
        } else if (zellquery.isFixed()) {
            this.value.setForeground(this.valuesFixedForeground);
            this.value.setFont(this.valuesFont);
        } else {
            this.value.setFont(this.valuesFont);
            this.value.setForeground(this.valuesValidForeground);
        }
        int wert = zellquery.getSymbol();
        if (wert == 0) {
            this.value.setText("");
        } else {
            this.value.setText("  " + zellquery.getSymbol());
        }
        int i = 0;
        while (i < this.memoLabels.length) {
            try {
                if (zellquery.isMemo(i + 1)) {
                    this.memoLabels[i].setForeground(this.valuesValidForeground);
                } else if (this.paintInFocusColor) {
                    this.memoLabels[i].setForeground(this.focusBackgroundColor);
                } else {
                    this.memoLabels[i].setForeground(this.nonFocusBackgroundColor);
                }
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
            ++i;
        }
        return this;
    }

    public void addCellRendererListener(CellRendererListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.put(listener, listener);
    }

    public void removeCellRendererListener(CellRendererListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public boolean isShowPossibilityCount() {
        return this.showPossibilityCount;
    }

    public void setShowPossibilityCount(boolean showPossibilityCount) {
        this.showPossibilityCount = showPossibilityCount;
    }

    protected void createMemoLabels() {
        int dim = 6;
        int xPos = 0;
        int yPos = 0;
        int cellDimension = this.optionsManager.getInteger("Cell.Dimension");
        this.memoLabels = new MemoLabel[9];
        int i = 0;
        while (i < this.memoLabels.length) {
            this.memoLabels[i] = new MemoLabel();
            ++i;
        }
        int xBox = 0;
        while (xBox < 3) {
            int yBox = 0;
            while (yBox < 3) {
                xPos = 7 + yBox * (cellDimension - 10) / 3;
                yPos = 7 + xBox * (cellDimension - 10) / 3;
                this.memoLabels[xBox * 3 + yBox].setBounds(xPos, yPos, dim, dim);
                this.add((Component)this.memoLabels[xBox * 3 + yBox], JLayeredPane.DEFAULT_LAYER);
                ++yBox;
            }
            ++xBox;
        }
    }

    protected JComponent createValue() {
        JLabel retVal = null;
        this.value = new JLabel();
        this.value.setBounds(this.xPos, this.yPos, this.width, this.height);
        this.value.setOpaque(false);
        retVal = this.value;
        return retVal;
    }

    protected void fireCellChanged(CellChangeEvent event) {
        if (this.listeners != null) {
            for (CellRendererListener l : this.listeners.values()) {
                l.cellChanged(event);
            }
        }
    }

    public void optionsChanged(OptionChangeEvent event) {
        super.optionsChanged(event);
        this.configureViewCellRenderer0(event);
    }

    public final void configureViewCellRenderer0(OptionChangeEvent event) {
        Color color;
        Font font;
        if ((event == null || event.isChanged("Givens.Font")) && (font = this.optionsManager.getFont("Givens.Font")) != null) {
            this.givensFont = font;
        }
        if ((event == null || event.isChanged("Givens.Foreground")) && (color = this.optionsManager.getColor("Givens.Foreground")) != null) {
            this.givensForegroundColor = color;
        }
        if ((event == null || event.isChanged("Values.Font")) && (font = this.optionsManager.getFont("Values.Font")) != null) {
            this.valuesFont = font;
        }
        if ((event == null || event.isChanged("Values.Fixed.Foreground")) && (color = this.optionsManager.getColor("Values.Fixed.Foreground")) != null) {
            this.valuesFixedForeground = color;
        }
    }
}

