/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.game.cellrenderer;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer1;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class CellRenderer2
extends CellRenderer1
implements TableCellRenderer {
    private JLabel possibilityCount = null;
    private Font possibilityFont = null;
    private Color possibilityColor = null;

    public CellRenderer2(OptionsManager optionsManager) {
        super(optionsManager);
        this.add((Component)this.createPossibilityCount(), JLayeredPane.PALETTE_LAYER);
        this.configureViewCellRenderer2(null);
    }

    public Component getTableCellRendererComponent(JTable table, Object cell, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, cell, isSelected, hasFocus, row, column);
        if (!(cell instanceof CellQuery)) {
            return this;
        }
        CellQuery cellQuery = (CellQuery)cell;
        if (this.showPossibilityCount) {
            if (!cellQuery.isGiven()) {
                int count = cellQuery.getPossibilities().length;
                this.possibilityCount.setFont(this.possibilityFont);
                this.possibilityCount.setForeground(this.possibilityColor);
                this.possibilityCount.setText("" + count);
            } else {
                this.possibilityCount.setText("");
            }
        } else {
            this.possibilityCount.setText("");
        }
        return this;
    }

    protected JComponent createPossibilityCount() {
        int xPos = 2;
        int yPos = 28;
        int width = 40;
        int height = 10;
        JLabel retVal = null;
        this.possibilityCount = new JLabel();
        this.possibilityCount.setBounds(xPos, yPos, width, height);
        this.possibilityCount.setForeground(this.possibilityColor);
        retVal = this.possibilityCount;
        return retVal;
    }

    public void optionsChanged(OptionChangeEvent event) {
        super.optionsChanged(event);
        this.configureViewCellRenderer2(event);
    }

    public final void configureViewCellRenderer2(OptionChangeEvent event) {
        Font font;
        Color color;
        if ((event == null || event.isChanged("Possiblity.Color")) && (color = this.optionsManager.getColor("Possiblity.Color")) != null) {
            this.possibilityColor = color;
        }
        if ((event == null || event.isChanged("Possiblity.Font")) && (font = this.optionsManager.getFont("Possiblity.Font")) != null) {
            this.possibilityFont = font;
        }
    }
}

