/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.options.OptionsEditor;
import de.gerdhirsch.soduko.view.options.SodukoEditor;
import de.gerdhirsch.soduko.view.options.StartUpEditor;
import de.gerdhirsch.soduko.view.options.colorfonteditor.OptionsEditorColorFont;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerApplyManager;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerDialog;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerUndoRedoable;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import de.gerdhirsch.util.resources.ReflexionActionListener;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class OptionsDialog
extends JFrame
implements TreeSelectionListener,
SodukoConstants,
LocalizeListener,
OptionsChangeListener {
    private LocalizeManager localizeManager = null;
    private OptionsManager originOptionsManager = null;
    private OptionsManagerApplyManager optionsManager = null;
    private OptionsManagerUndoRedoable optionsManagerUrha = null;
    private JTree tree = null;
    private JScrollPane treeView = null;
    private JSplitPane splitPane = null;
    private Dimension treeMinDimension = new Dimension(160, 0);
    private Dimension treeMaxDimension = new Dimension(300, 0);
    private JPanel emptyEditor = null;
    private JPanel optionsEditor = null;
    protected Dimension editorDimension = new Dimension(450, 0);
    private JToolBar toolBar = null;
    private JPanel buttonPanel = null;
    private ArrayList<ReflexionActionListener> actions = new ArrayList();
    private AbstractAction undoAction = null;
    private AbstractAction redoAction = null;

    public OptionsDialog(OptionsManager originOptionsManager, LocalizeManager localizeManager, UndoRedoHandler urha) {
        this.originOptionsManager = originOptionsManager;
        this.localizeManager = localizeManager;
        OptionsManagerDialog dom = new OptionsManagerDialog(this.originOptionsManager);
        this.optionsManagerUrha = new OptionsManagerUndoRedoable(dom, urha);
        this.optionsManager = new OptionsManagerApplyManager(this.optionsManagerUrha);
        this.optionsManager.addOptionsChangeListener(this);
        this.localizeManager.addLocalizeListener(this);
        this.setTitle(localizeManager.getString("Options.Title"));
        this.createView();
    }

    private void createView() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        this.tree = new JTree(this.createNodes());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(this);
        this.treeView = new JScrollPane(this.tree);
        this.treeView.setMinimumSize(this.treeMinDimension);
        this.treeView.setMaximumSize(this.treeMaxDimension);
        this.createButtonPanel();
        this.createToolBar();
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(this.treeView);
        this.splitPane.setRightComponent(new SodukoEditor("Title", this.localizeManager.getString("Title"), this.optionsManager, this.localizeManager));
        this.splitPane.setDividerLocation(160);
        this.tree.setSelectionRow(0);
        this.add((Component)this.toolBar, "First");
        this.add((Component)this.buttonPanel, "Last");
        this.add((Component)this.splitPane, "Center");
        this.checkViewState();
    }

    private JPanel createButtonPanel() {
        String key = null;
        ReflexionActionListener action = null;
        this.buttonPanel = new JPanel();
        JToolBar toolBar = new JToolBar("Button ToolBar");
        toolBar.setFloatable(false);
        Dimension separatorDimension = new Dimension(0, 0);
        Dimension separatorBorderDimension = new Dimension(0, 0);
        toolBar.addSeparator(separatorBorderDimension);
        key = "Options.Apply";
        action = ReflexionActionListener.createAction(this, "applyAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        toolBar.add(action);
        toolBar.addSeparator(separatorDimension);
        key = "Options.RestoreDefaults";
        action = ReflexionActionListener.createAction(this, "restoreDefaultsAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        toolBar.add(action);
        toolBar.addSeparator(separatorDimension);
        key = "Options.Ok";
        action = ReflexionActionListener.createAction(this, "okAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        toolBar.add(action);
        toolBar.addSeparator(separatorDimension);
        key = "Options.Cancel";
        action = ReflexionActionListener.createAction(this, "cancelAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        toolBar.add(action);
        toolBar.addSeparator(separatorBorderDimension);
        this.buttonPanel.add(toolBar);
        return this.buttonPanel;
    }

    private JToolBar createToolBar() {
        String key = null;
        ReflexionActionListener action = null;
        this.toolBar = new JToolBar("Option ToolBar");
        key = "Menu.Edit.Undo";
        action = ReflexionActionListener.createAction(this, "undoAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.undoAction = action;
        key = "Menu.Edit.Redo";
        action = ReflexionActionListener.createAction(this, "redoAction", key);
        this.localizeAction(action);
        this.actions.add(action);
        this.redoAction = action;
        this.toolBar.add(this.undoAction);
        this.toolBar.add(this.redoAction);
        return this.toolBar;
    }

    private DefaultMutableTreeNode createNodes() {
        DefaultMutableTreeNode topNode = new DefaultMutableTreeNode(new SodukoEditor("Title", this.localizeManager.getString("Title"), this.optionsManager, this.localizeManager));
        DefaultMutableTreeNode category = null;
        category = new DefaultMutableTreeNode(new OptionsEditorColorFont("Soduko", this.localizeManager.getString("Soduko"), this.optionsManager, this.localizeManager));
        topNode.add(category);
        category = new DefaultMutableTreeNode(new StartUpEditor("Startup.Description", this.localizeManager.getString("Startup.Description"), this.optionsManager, this.localizeManager));
        topNode.add(category);
        return topNode;
    }

    public void localeChanged(EventObject event) {
        this.setTitle(this.localizeManager.getString("Options.Title"));
        this.localizeActions();
        this.localizeTree();
    }

    private void localizeTree() {
        if (this.tree == null) {
            return;
        }
        TreeModel treeModel = this.tree.getModel();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode child = null;
        OptionsEditor oe = (OptionsEditor)root.getUserObject();
        String key = oe.getKey();
        oe.setNodeName(this.localizeManager.getString(key));
        Enumeration<TreeNode> enumeration = root.children();
        while (enumeration.hasMoreElements()) {
            child = (DefaultMutableTreeNode)enumeration.nextElement();
            oe = (OptionsEditor)child.getUserObject();
            key = oe.getKey();
            oe.setNodeName(this.localizeManager.getString(key));
        }
        this.tree.updateUI();
    }

    private void localizeAction(ReflexionActionListener action) {
        String key = (String)action.getValue("ResourceKey");
        HashMap<String, Object> map = this.localizeManager.loadKey(this, key, ";", ":", "&");
        ReflexionActionListener.configureAction(action, map);
    }

    private void localizeActions() {
        for (ReflexionActionListener action : this.actions) {
            this.localizeAction(action);
        }
    }

    public void optionsChanged(OptionChangeEvent event) {
        Locale locale = this.optionsManager.getLocale("Locale");
        if (event.isChanged("Locale") && locale != null) {
            this.localizeManager.setLocale(locale);
        }
        if (event.isChanged("Options.Look.And.Feel")) {
            try {
                UIManager.setLookAndFeel(this.optionsManager.getString("Options.Look.And.Feel"));
                SwingUtilities.updateComponentTreeUI(this);
            }
            catch (Exception e) {
                e.printStackTrace();
                JFrame.setDefaultLookAndFeelDecorated(true);
            }
        }
        this.checkViewState();
    }

    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        this.optionsEditor = (JPanel)node.getUserObject();
        if (this.optionsEditor != null) {
            JScrollPane scrollPane = new JScrollPane(this.optionsEditor);
            scrollPane.setMinimumSize(this.editorDimension);
            this.splitPane.setRightComponent(scrollPane);
        } else {
            this.splitPane.setRightComponent(this.emptyEditor);
        }
    }

    public void setVisible(boolean isVisible) {
        super.setVisible(isVisible);
        if (isVisible) {
            this.optionsManager.back2Applied();
            this.checkViewState();
        }
    }

    private void checkViewState() {
        OptionsManagerUndoRedoable om = (OptionsManagerUndoRedoable)this.optionsManager.getActualOptionsManager();
        UndoRedoHandler urha = om.getUndoRedoHandler();
        if (urha.isUndoable()) {
            this.undoAction.setEnabled(true);
        } else {
            this.undoAction.setEnabled(false);
        }
        if (urha.isRedoable()) {
            this.redoAction.setEnabled(true);
        } else {
            this.redoAction.setEnabled(false);
        }
    }

    private void applyAction(ActionEvent event) {
        this.optionsManager.apply();
        this.checkViewState();
    }

    private void cancelAction(ActionEvent event) {
        this.setVisible(false);
    }

    private void restoreDefaultsAction(ActionEvent event) {
        this.optionsManager.restoreDefaults();
        this.checkViewState();
    }

    private void okAction(ActionEvent event) {
        this.optionsManager.apply();
        this.setVisible(false);
    }

    private void undoAction(ActionEvent event) {
        try {
            OptionsManagerUndoRedoable om = (OptionsManagerUndoRedoable)this.optionsManager.getActualOptionsManager();
            om.getUndoRedoHandler().undo();
            this.checkViewState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void redoAction(ActionEvent event) {
        try {
            OptionsManagerUndoRedoable om = (OptionsManagerUndoRedoable)this.optionsManager.getActualOptionsManager();
            om.getUndoRedoHandler().redo();
            this.checkViewState();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

