/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options;

import de.gerdhirsch.soduko.view.options.ListItem;
import de.gerdhirsch.soduko.view.options.OptionsEditor;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocaleItem;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class SodukoEditor
extends OptionsEditor
implements LocalizeListener {
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private JComboBox languageComboBox = null;
    private JLabel languageLabel = null;
    private LocaleItem[] localeItems = null;
    private ListItem[] lookAndFeelItems = null;
    private JComboBox lookAndFeelBox = null;
    private JLabel lookLabel = null;
    private LocaleItem lastLocaleItem = null;
    private ListItem lastLookAndFeelItem = null;

    public SodukoEditor(String key, String nodeName, OptionsManager optionsManager, LocalizeManager localizeManager) {
        super(key, nodeName);
        this.localizeManager = localizeManager;
        this.optionsManager = optionsManager;
        localizeManager.addLocalizeListener(this);
        optionsManager.addOptionsChangeListener(this);
        this.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        this.createLocaleBox();
        this.createLookAndFeelBox();
    }

    private void createLookAndFeelBox() {
        this.lookLabel = new JLabel(this.localizeManager.getString("Look.And.Feel.Description"));
        UIManager.LookAndFeelInfo[] infos = UIManager.getInstalledLookAndFeels();
        this.lookAndFeelItems = new ListItem[infos.length];
        ListItem actualItem = null;
        String actualLookAndFeelClassName = this.optionsManager.getString("Options.Look.And.Feel");
        int i = 0;
        while (i < infos.length) {
            this.lookAndFeelItems[i] = new ListItem(infos[i].getName(), infos[i].getClassName());
            if (actualLookAndFeelClassName.equals(infos[i].getClassName())) {
                actualItem = this.lookAndFeelItems[i];
            }
            ++i;
        }
        this.lookAndFeelBox = new JComboBox<ListItem>(this.lookAndFeelItems);
        this.lookAndFeelBox.setSelectedItem(actualItem);
        this.lookAndFeelBox.addItemListener(new LookAndFeelListener());
        this.add(this.lookLabel);
        this.add(this.lookAndFeelBox);
    }

    private void createLocaleBox() {
        Locale[] locales = this.localizeManager.getLocales();
        String key = "Language";
        String language = null;
        this.localeItems = new LocaleItem[locales.length];
        Locale actualLocale = this.localizeManager.getLocale();
        LocaleItem actualLocaleItem = null;
        int i = 0;
        while (i < locales.length) {
            this.localizeManager.setLocale(locales[i]);
            language = this.localizeManager.getString(key);
            this.localeItems[i] = new LocaleItem(language, locales[i]);
            if (actualLocale.equals(locales[i])) {
                actualLocaleItem = this.localeItems[i];
            }
            ++i;
        }
        this.languageComboBox = new JComboBox<LocaleItem>(this.localeItems);
        this.languageComboBox.setSelectedItem(actualLocaleItem);
        this.lastLocaleItem = actualLocaleItem;
        this.localizeManager.setLocale(actualLocale);
        this.languageComboBox.addItemListener(new LocaleListener());
        this.languageLabel = new JLabel();
        this.languageLabel.setText(this.localizeManager.getString("Locale.Description"));
        this.add(this.languageLabel);
        this.add(this.languageComboBox);
    }

    public void localeChanged(EventObject event) {
        this.localizeLookLabel();
        this.localizeComboBox();
    }

    private void localizeLookLabel() {
        if (this.lookLabel == null) {
            return;
        }
        this.lookLabel.setText(this.localizeManager.getString("Look.And.Feel.Description"));
    }

    private void localizeComboBox() {
        if (this.languageLabel == null) {
            return;
        }
        this.languageLabel.setText(this.localizeManager.getString("Locale.Description"));
        Locale locale = this.localizeManager.getLocale();
        Locale localeFromItem = null;
        int i = 0;
        while (i < this.localeItems.length) {
            if (this.localeItems[i].getLocale().equals(locale)) {
                localeFromItem = this.localeItems[i].getLocale();
                this.languageComboBox.setSelectedItem(this.localeItems[i]);
                break;
            }
            ++i;
        }
    }

    public void optionsChanged(OptionChangeEvent event) {
        if (event.isChanged("Options.Look.And.Feel")) {
            this.setLookAndFeel(this.optionsManager.getString("Options.Look.And.Feel"));
        }
    }

    private void setLookAndFeel(String lookAndFeel) {
        int i = 0;
        while (i < this.lookAndFeelItems.length) {
            String lookAndFeelClass = (String)this.lookAndFeelItems[i].getValue();
            if (lookAndFeel.equals(lookAndFeelClass)) {
                this.lookAndFeelBox.setSelectedItem(this.lookAndFeelItems[i]);
                break;
            }
            ++i;
        }
    }

    public class LocaleListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (SodukoEditor.this.lastLocaleItem == event.getItem()) {
                return;
            }
            SodukoEditor.this.lastLocaleItem = (LocaleItem)event.getItem();
            Locale locale = SodukoEditor.this.lastLocaleItem.getLocale();
            SodukoEditor.this.optionsManager.putValue("Locale", locale);
        }
    }

    public class LookAndFeelListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (SodukoEditor.this.lastLookAndFeelItem == event.getItem()) {
                return;
            }
            SodukoEditor.this.lastLookAndFeelItem = (ListItem)event.getItem();
            String lookAndFeel = (String)SodukoEditor.this.lastLookAndFeelItem.getValue();
            SodukoEditor.this.optionsManager.putValue("Options.Look.And.Feel", lookAndFeel);
        }
    }
}

