/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options;

import de.gerdhirsch.soduko.view.options.OptionsEditor;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StartUpEditor
extends OptionsEditor
implements ActionListener,
ChangeListener,
LocalizeListener {
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private JLabel supportLabel = null;
    private JSlider supportLevelSlider = null;
    private ButtonGroup tabButtonGroup = null;
    private JRadioButton showTabButton = null;
    private JRadioButton hideTabButton = null;
    private ButtonGroup cursorButtonGroup = null;
    private JRadioButton standardCursorButton = null;
    private JRadioButton inputCursorButton = null;

    public StartUpEditor(String key, String nodeName, OptionsManager om, LocalizeManager localizeManager) {
        super(key, nodeName);
        this.localizeManager = localizeManager;
        this.optionsManager = om;
        localizeManager.addLocalizeListener(this);
        this.optionsManager.addOptionsChangeListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(50, 50, 50, 50));
        this.createSlider();
        this.createTabRadioButtons();
        this.createCursorRadioButtons();
    }

    private void createSlider() {
        int defaultSupportLevel = this.optionsManager.getInteger("Default.Supportlevel");
        int maxSupportLevel = this.optionsManager.getInteger("Max.Supportlevel");
        this.supportLabel = new JLabel(this.localizeManager.getString("Default.Support.Level.Description"));
        this.supportLevelSlider = new JSlider(0, 0, maxSupportLevel, defaultSupportLevel);
        this.supportLevelSlider.setMajorTickSpacing(1);
        this.supportLevelSlider.setMinorTickSpacing(1);
        this.supportLevelSlider.setPaintTicks(true);
        this.supportLevelSlider.setPaintLabels(true);
        this.supportLevelSlider.setSnapToTicks(true);
        this.supportLevelSlider.addChangeListener(this);
        this.supportLevelSlider.setOpaque(false);
        JPanel sliderPanel = new JPanel();
        sliderPanel.add(this.supportLabel);
        sliderPanel.add(this.supportLevelSlider);
        this.add(sliderPanel);
    }

    private void createTabRadioButtons() {
        this.showTabButton = new JRadioButton(this.localizeManager.getString("Default.Show.Tab.Description"));
        this.showTabButton.setSelected(true);
        this.showTabButton.setActionCommand("show");
        this.showTabButton.addActionListener(this);
        this.hideTabButton = new JRadioButton(this.localizeManager.getString("Default.Hide.Tab.Description"));
        this.hideTabButton.setActionCommand("hide");
        this.hideTabButton.addActionListener(this);
        this.tabButtonGroup = new ButtonGroup();
        this.tabButtonGroup.add(this.hideTabButton);
        this.tabButtonGroup.add(this.showTabButton);
        JPanel tabButtonPanel = new JPanel();
        tabButtonPanel.add(this.hideTabButton);
        tabButtonPanel.add(this.showTabButton);
        this.add(tabButtonPanel);
    }

    private void createCursorRadioButtons() {
        this.standardCursorButton = new JRadioButton(this.localizeManager.getString("Default.Standard.Cursor.Description"));
        this.standardCursorButton.setSelected(true);
        this.standardCursorButton.setActionCommand("standard");
        this.standardCursorButton.addActionListener(this);
        this.inputCursorButton = new JRadioButton(this.localizeManager.getString("Default.Input.Cursor.Description"));
        this.inputCursorButton.setActionCommand("input");
        this.inputCursorButton.addActionListener(this);
        this.cursorButtonGroup = new ButtonGroup();
        this.cursorButtonGroup.add(this.inputCursorButton);
        this.cursorButtonGroup.add(this.standardCursorButton);
        JPanel cursorButtonPanel = new JPanel();
        cursorButtonPanel.add(this.inputCursorButton);
        cursorButtonPanel.add(this.standardCursorButton);
        this.add(cursorButtonPanel);
    }

    public void localeChanged(EventObject event) {
        this.localizeSupportLevelEditor();
        this.localizeRadioButtons();
    }

    private void localizeSupportLevelEditor() {
        if (this.supportLabel == null) {
            return;
        }
        this.supportLabel.setText(this.localizeManager.getString("Default.Support.Level.Description"));
    }

    private void localizeRadioButtons() {
        if (this.showTabButton == null || this.hideTabButton == null) {
            return;
        }
        this.showTabButton.setText(this.localizeManager.getString("Default.Show.Tab.Description"));
        this.hideTabButton.setText(this.localizeManager.getString("Default.Hide.Tab.Description"));
        this.standardCursorButton.setText(this.localizeManager.getString("Default.Standard.Cursor.Description"));
        this.inputCursorButton.setText(this.localizeManager.getString("Default.Input.Cursor.Description"));
    }

    public void optionsChanged(OptionChangeEvent event) {
        if (event.isChanged("Default.Supportlevel")) {
            this.supportLevelSlider.setValue(this.optionsManager.getInteger("Default.Supportlevel"));
        }
        if (event.isChanged("Soduko.X.Size")) {
            if (this.optionsManager.getInteger("Soduko.X.Size") == 396) {
                this.hideTabButton.setSelected(true);
            } else {
                this.showTabButton.setSelected(true);
            }
        }
        if (event.isChanged("Cursor.Style")) {
            if (this.optionsManager.getString("Cursor.Style") == "Symbol.Set") {
                this.inputCursorButton.setSelected(true);
            } else {
                this.standardCursorButton.setSelected(true);
            }
        }
    }

    public void stateChanged(ChangeEvent event) {
        if (!this.supportLevelSlider.getValueIsAdjusting()) {
            int supportLevel = this.supportLevelSlider.getValue();
            switch (supportLevel) {
                case 0: {
                    this.optionsManager.putValue("Default.Supportlevel", 0);
                    break;
                }
                case 1: {
                    this.optionsManager.putValue("Default.Supportlevel", 1);
                    break;
                }
                case 2: {
                    this.optionsManager.putValue("Default.Supportlevel", 2);
                    break;
                }
                case 3: {
                    this.optionsManager.putValue("Default.Supportlevel", 3);
                    break;
                }
                case 4: {
                    this.optionsManager.putValue("Default.Supportlevel", 4);
                    break;
                }
            }
        }
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("hide")) {
            this.optionsManager.putValue("Soduko.X.Size", 396);
        }
        if (event.getActionCommand().equals("show")) {
            this.optionsManager.putValue("Soduko.X.Size", 610);
        }
        if (event.getActionCommand().equals("standard")) {
            this.optionsManager.putValue("Cursor.Style", null);
        }
        if (event.getActionCommand().equals("input")) {
            this.optionsManager.putValue("Cursor.Style", "Symbol.Set");
        }
    }
}

