/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.colorfonteditor;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.options.colorfonteditor.ColorEditor;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooserDialog
extends JDialog
implements ChangeListener,
SodukoConstants {
    private LocalizeManager localizeManager = null;
    private ColorEditor colorEditor = null;
    private JColorChooser colorChooser = null;
    private Color currentColor = null;
    private ColorSelectionModel colorSelectionModel = null;
    private final Rectangle dialogSize = new Rectangle(100, 100, 425, 420);
    private JPanel colorChooserPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;

    public ColorChooserDialog(JFrame owner, String title, boolean modal, LocalizeManager localizeManager, OptionsManager om, ColorEditor ce) {
        super(owner, title, modal);
        this.localizeManager = localizeManager;
        this.colorEditor = ce;
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setBounds(this.dialogSize);
        this.createJColorChooser();
        this.createButtons();
        this.add(this.colorChooserPanel);
    }

    private void createJColorChooser() {
        this.colorChooser = new JColorChooser();
        this.colorSelectionModel = this.colorChooser.getSelectionModel();
        this.colorSelectionModel.addChangeListener(this);
        this.colorChooserPanel = new JPanel();
        this.colorChooserPanel.add(this.colorChooser);
    }

    private void createButtons() {
        this.okButton = new JButton(this.localizeManager.getString("Ok.Description"));
        this.okButton.addActionListener(new OkListener());
        this.cancelButton = new JButton(this.localizeManager.getString("Cancel.Description"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                ColorChooserDialog.this.setVisible(false);
            }
        });
        this.colorChooserPanel.add(this.okButton);
        this.colorChooserPanel.add(this.cancelButton);
    }

    public void stateChanged(ChangeEvent event) {
        this.currentColor = this.colorSelectionModel.getSelectedColor();
    }

    public void setCurrentColor(Color currentColor) {
        this.currentColor = currentColor;
        this.colorChooser.setColor(currentColor);
        this.colorSelectionModel.setSelectedColor(currentColor);
    }

    public class OkListener
    implements ActionListener {
        public void actionPerformed(ActionEvent event) {
            ColorChooserDialog.this.colorEditor.setCellEditorValue(ColorChooserDialog.this.currentColor);
            ColorChooserDialog.this.setVisible(false);
        }
    }
}

