/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.colorfonteditor;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.options.colorfonteditor.ColorChooserDialog;
import de.gerdhirsch.soduko.view.options.colorfonteditor.OptionsTableModel;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ColorEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
SodukoConstants,
LocalizeListener {
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private JButton chooseButton = null;
    private ColorChooserDialog colorChooserDialog = null;
    private OptionsTableModel optionsTableModel = null;
    private Color currentColor = null;
    private String title = null;
    private String localizedTitle = null;
    private String pressedButtonText = null;
    private int actualRow = 0;

    public ColorEditor(LocalizeManager localizeManager, OptionsManager om, OptionsTableModel optionsTableModel) {
        this.localizeManager = localizeManager;
        this.optionsManager = om;
        this.optionsTableModel = optionsTableModel;
        localizeManager.addLocalizeListener(this);
        this.colorChooserDialog = new ColorChooserDialog(null, this.title, true, localizeManager, this.optionsManager, this);
        this.chooseButton = new JButton();
        this.chooseButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.optionsTableModel == null) {
            return;
        }
        Object value = this.optionsTableModel.getValueAt(this.actualRow, 0);
        this.title = String.valueOf(this.localizedTitle) + " - " + value;
        this.chooseButton.setBackground(this.currentColor);
        this.chooseButton.setText(this.pressedButtonText);
        this.colorChooserDialog.setCurrentColor(this.currentColor);
        this.colorChooserDialog.setTitle(this.title);
        this.colorChooserDialog.setVisible(true);
        this.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        return this.currentColor;
    }

    public void setCellEditorValue(Color value) {
        this.currentColor = value;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.actualRow = row;
        this.currentColor = (Color)value;
        return this.chooseButton;
    }

    public void localeChanged(EventObject event) {
        this.localizedTitle = this.localizeManager.getString("Color.Title");
        this.pressedButtonText = this.localizeManager.getString("InUse.Description");
    }
}

