/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.colorfonteditor;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.options.ListItem;
import de.gerdhirsch.soduko.view.options.colorfonteditor.FontEditor;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class FontChooserDialog
extends JDialog
implements SodukoConstants,
OptionsChangeListener {
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private FontEditor fontEditor = null;
    private GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
    private final Rectangle dialogSize = new Rectangle(100, 100, 320, 95);
    private JPanel fontChooserPanel = null;
    private JButton okButton = null;
    private JButton cancelButton = null;
    private Font currentFont = null;
    private JComboBox fontNameComboBox = null;
    private String[] allFontNames = this.ge.getAvailableFontFamilyNames();
    private String fontName = null;
    private JComboBox fontStyleComboBox = null;
    private ListItem[] fontStyleItems = null;
    private final int boldItalicStyle = 3;
    private int fontStyle = 0;
    private JComboBox fontSizeComboBox = null;
    private int fontSize = 0;

    public FontChooserDialog(JFrame owner, String title, boolean modal, LocalizeManager localizeManager, OptionsManager om, FontEditor fe) {
        super(owner, title, modal);
        this.localizeManager = localizeManager;
        this.optionsManager = om;
        this.fontEditor = fe;
        this.optionsManager.addOptionsChangeListener(this);
        this.ge.preferLocaleFonts();
        this.setResizable(false);
        this.setAlwaysOnTop(true);
        this.setBounds(this.dialogSize);
        this.createFontChooser();
        this.add(this.fontChooserPanel);
    }

    private void createFontChooser() {
        this.fontChooserPanel = new JPanel();
        this.createFontNameComboBox();
        this.createFontStyles();
        this.createFontStyleComboBox();
        this.createFontSizeComboBox();
        this.createButtons();
    }

    private void createFontNameComboBox() {
        this.fontNameComboBox = new JComboBox<String>(this.allFontNames);
        this.fontNameComboBox.addItemListener(new FontNameListener());
        this.fontChooserPanel.add(this.fontNameComboBox);
    }

    private void createFontStyles() {
        int fontStylesCount = 4;
        String[] styleDescriptions = new String[]{this.localizeManager.getString("Font.Plain.Description"), this.localizeManager.getString("Font.Bold.Description"), this.localizeManager.getString("Font.Italic.Description"), this.localizeManager.getString("Font.Bold.Italic.Description")};
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        int[] fontStyles = nArray;
        this.fontStyleItems = new ListItem[4];
        int i = 0;
        while (i < 4) {
            this.fontStyleItems[i] = new ListItem(styleDescriptions[i], fontStyles[i]);
            ++i;
        }
    }

    private void createFontStyleComboBox() {
        this.fontStyleComboBox = new JComboBox<ListItem>(this.fontStyleItems);
        this.fontStyleComboBox.addItemListener(new FontStyleListener());
        this.fontChooserPanel.add(this.fontStyleComboBox);
    }

    private void createFontSizeComboBox() {
        String[] fontSizeItems = new String[]{"7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25"};
        this.fontSizeComboBox = new JComboBox<String>(fontSizeItems);
        this.fontSizeComboBox.addItemListener(new FontSizeListener());
        this.fontChooserPanel.add(this.fontSizeComboBox);
    }

    private void createButtons() {
        this.okButton = new JButton(this.localizeManager.getString("Ok.Description"));
        this.okButton.addActionListener(new OkListener());
        this.cancelButton = new JButton(this.localizeManager.getString("Cancel.Description"));
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                FontChooserDialog.this.setVisible(false);
            }
        });
        this.fontChooserPanel.add(this.okButton);
        this.fontChooserPanel.add(this.cancelButton);
    }

    public void optionsChanged(OptionChangeEvent event) {
    }

    public void setCurrentFont(Font currentFont) {
        this.currentFont = currentFont;
        String name = currentFont.getName();
        this.fontNameComboBox.setSelectedItem(name);
        int style = currentFont.getStyle();
        this.fontStyleComboBox.setSelectedIndex(style);
        int size = currentFont.getSize();
        this.fontSizeComboBox.setSelectedItem(Integer.toString(size));
    }

    public class FontNameListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            FontChooserDialog.this.fontName = event.getItem().toString();
        }
    }

    public class FontStyleListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            FontChooserDialog.this.fontStyle = FontChooserDialog.this.fontStyleComboBox.getSelectedIndex();
        }
    }

    public class FontSizeListener
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            FontChooserDialog.this.fontSize = Integer.parseInt((String)FontChooserDialog.this.fontSizeComboBox.getSelectedItem());
        }
    }

    private class OkListener
    implements ActionListener {
        private Font newFont = null;

        OkListener() {
        }

        public void actionPerformed(ActionEvent event) {
            this.newFont = new Font(FontChooserDialog.this.fontName, FontChooserDialog.this.fontStyle, FontChooserDialog.this.fontSize);
            FontChooserDialog.this.fontEditor.setCellEditorValue(this.newFont);
            FontChooserDialog.this.setVisible(false);
        }
    }
}

