/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.colorfonteditor;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.options.colorfonteditor.FontChooserDialog;
import de.gerdhirsch.soduko.view.options.colorfonteditor.OptionsTableModel;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class FontEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener,
SodukoConstants,
LocalizeListener {
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private JButton chooseButton = null;
    private FontChooserDialog fontChooserDialog = null;
    private OptionsTableModel optionsTableModel = null;
    private Font currentFont = null;
    private String title = null;
    private String localizedTitle = null;
    private int actualRow = 0;

    public FontEditor(LocalizeManager localizeManager, OptionsManager om, OptionsTableModel optionsTableModel) {
        this.localizeManager = localizeManager;
        this.optionsManager = om;
        this.optionsTableModel = optionsTableModel;
        localizeManager.addLocalizeListener(this);
        this.fontChooserDialog = new FontChooserDialog(null, this.title, true, localizeManager, this.optionsManager, this);
        this.chooseButton = new JButton();
        this.chooseButton.addActionListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        if (this.optionsTableModel == null) {
            return;
        }
        String value = (String)this.optionsTableModel.getValueAt(this.actualRow, 0);
        this.title = String.valueOf(this.localizedTitle) + " - " + value;
        this.fontChooserDialog.setCurrentFont(this.currentFont);
        this.fontChooserDialog.setTitle(this.title);
        this.fontChooserDialog.setVisible(true);
        this.fireEditingStopped();
    }

    public Object getCellEditorValue() {
        return this.currentFont;
    }

    public void setCellEditorValue(Font newFont) {
        this.currentFont = newFont;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.actualRow = row;
        this.currentFont = (Font)value;
        return this.chooseButton;
    }

    public void localeChanged(EventObject event) {
        this.localizedTitle = this.localizeManager.getString("Font.Title");
        this.chooseButton.setText(this.localizeManager.getString("InUse.Description"));
    }
}

