/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.colorfonteditor;

import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer0;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer1;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer2;
import de.gerdhirsch.soduko.view.options.OptionsEditor;
import de.gerdhirsch.soduko.view.options.colorfonteditor.ColorEditor;
import de.gerdhirsch.soduko.view.options.colorfonteditor.ColorRenderer;
import de.gerdhirsch.soduko.view.options.colorfonteditor.FontEditor;
import de.gerdhirsch.soduko.view.options.colorfonteditor.FontRenderer;
import de.gerdhirsch.soduko.view.options.colorfonteditor.OptionsTable;
import de.gerdhirsch.soduko.view.options.colorfonteditor.OptionsTableModel;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class OptionsEditorColorFont
extends OptionsEditor
implements ChangeListener,
LocalizeListener,
SodukoConstants {
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private JSlider supportLevelSlider = null;
    private JPanel sliderPanel = null;
    private JLabel sliderLabel = null;
    private CellRenderer0 level0 = null;
    private CellRenderer0 level1 = null;
    private CellRenderer0 level2 = null;
    private CellRenderer0[] cellRenderer = null;
    private ColorRenderer colorRenderer = null;
    private FontRenderer fontRenderer = null;
    private JTable optionsTable = null;
    private OptionsTableModel optionsTableModel = null;
    private DefaultCellEditor cellEditor = null;
    private DefaultTableColumnModel columnModelSudoku = null;
    private String[] toolTipTexts = new String[5];
    private String[] columnHeaderKeys = new String[]{"Description.Description", "Color.Description", "Font.Description", "Nonfocus.Description", "Focus.Description"};
    private JFormattedTextField editor = null;

    public OptionsEditorColorFont(String key, String nodeName, OptionsManager om, LocalizeManager localizeManager) {
        super(key, nodeName);
        this.localizeManager = localizeManager;
        this.optionsManager = om;
        localizeManager.addLocalizeListener(this);
        this.level0 = new CellRenderer0(this.optionsManager);
        this.level1 = new CellRenderer1(this.optionsManager);
        this.level2 = new CellRenderer2(this.optionsManager);
        this.cellRenderer = new CellRenderer0[]{this.level0, this.level1, this.level2, this.level2, this.level2};
        this.level2.setShowPossibilityCount(true);
        this.setLayout(new BorderLayout());
        this.createTable();
    }

    private void createTable() {
        this.editor = new JFormattedTextField();
        this.editor.setFont(DEFAULT_FONT);
        this.cellEditor = new DefaultCellEditor(this.editor);
        this.optionsTableModel = new OptionsTableModel(this.localizeManager, this.optionsManager, this.level2);
        ColorEditor colorEditor = new ColorEditor(this.localizeManager, this.optionsManager, this.optionsTableModel);
        FontEditor fontEditor = new FontEditor(this.localizeManager, this.optionsManager, this.optionsTableModel);
        DefaultTableCellRenderer defaultRenderer = new DefaultTableCellRenderer();
        this.colorRenderer = new ColorRenderer(this.localizeManager);
        this.fontRenderer = new FontRenderer(this.localizeManager);
        TableColumn col = null;
        this.columnModelSudoku = new DefaultTableColumnModel();
        int cellDimension = this.optionsManager.getInteger("Cell.Dimension");
        int defaultSupportLevel = this.optionsManager.getInteger("Default.Supportlevel");
        col = new TableColumn(0, cellDimension);
        col.setPreferredWidth(90);
        col.setCellRenderer(defaultRenderer);
        col.setHeaderValue(this.localizeManager.getString("Description.Description"));
        this.columnModelSudoku.addColumn(col);
        col = new TableColumn(1, cellDimension);
        col.setCellRenderer(this.colorRenderer);
        col.setCellEditor(colorEditor);
        col.setHeaderValue(this.localizeManager.getString("Color.Description"));
        this.columnModelSudoku.addColumn(col);
        col = new TableColumn(2, cellDimension);
        col.setCellRenderer(this.fontRenderer);
        col.setCellEditor(fontEditor);
        col.setHeaderValue(this.localizeManager.getString("Font.Description"));
        this.columnModelSudoku.addColumn(col);
        col = new TableColumn(3, cellDimension);
        col.setCellRenderer(this.level2);
        col.setCellEditor(this.cellEditor);
        col.setHeaderValue(this.localizeManager.getString("Nonfocus.Description"));
        this.columnModelSudoku.addColumn(col);
        col = new TableColumn(4, cellDimension);
        col.setCellRenderer(this.cellRenderer[defaultSupportLevel]);
        col.setCellEditor(this.cellEditor);
        col.setHeaderValue(this.localizeManager.getString("Focus.Description"));
        this.columnModelSudoku.addColumn(col);
        this.optionsTable = new OptionsTable(this.optionsTableModel, this.columnModelSudoku, this.toolTipTexts);
        this.optionsTable.setRowHeight(cellDimension);
        this.createSliderAndLabel();
        JScrollPane scrollPane = new JScrollPane(this.optionsTable);
        this.add((Component)this.sliderPanel, "North");
        this.add((Component)scrollPane, "Center");
    }

    private JPanel createSliderAndLabel() {
        this.sliderLabel = new JLabel(this.localizeManager.getString("TabSupport.Label"));
        this.supportLevelSlider = new JSlider(0, 0, 2, 2);
        this.supportLevelSlider.setMajorTickSpacing(1);
        this.supportLevelSlider.setMinorTickSpacing(1);
        this.supportLevelSlider.setPaintTicks(true);
        this.supportLevelSlider.setPaintLabels(true);
        this.supportLevelSlider.setSnapToTicks(true);
        this.supportLevelSlider.addChangeListener(this);
        this.supportLevelSlider.setOpaque(false);
        this.sliderPanel = new JPanel();
        this.sliderPanel.add(this.sliderLabel);
        this.sliderPanel.add(this.supportLevelSlider);
        return this.sliderPanel;
    }

    public void localeChanged(EventObject event) {
        this.localizeView(event);
        this.localizeToolTips();
    }

    protected void localizeView(EventObject event) {
        TableColumnModel columnModel = this.optionsTable.getColumnModel();
        int columnCount = columnModel.getColumnCount();
        TableColumn column = null;
        int c = 0;
        while (c < columnCount) {
            column = columnModel.getColumn(c);
            column.setHeaderValue(this.localizeManager.getString(this.columnHeaderKeys[c]));
            ++c;
        }
        this.sliderLabel.setText(this.localizeManager.getString("Support.Level.Description"));
    }

    private void localizeToolTips() {
        this.toolTipTexts[0] = this.localizeManager.getString("Tooltip.Description.Description");
        this.toolTipTexts[1] = this.localizeManager.getString("Tooltip.Color.Description");
        this.toolTipTexts[2] = this.localizeManager.getString("Tooltip.Font.Description");
        this.toolTipTexts[3] = this.localizeManager.getString("Tooltip.Nonfocus.Description");
        this.toolTipTexts[4] = this.localizeManager.getString("Tooltip.Focus.Description");
    }

    public void optionsChanged(OptionChangeEvent event) {
    }

    public void stateChanged(ChangeEvent event) {
        if (!this.supportLevelSlider.getValueIsAdjusting()) {
            int supportLevel = this.supportLevelSlider.getValue();
            this.optionsTableModel.setSupportLevel(supportLevel);
            TableColumnModel columnModel = this.optionsTable.getColumnModel();
            switch (supportLevel) {
                case 0: {
                    columnModel.getColumn(3).setCellRenderer(this.level0);
                    columnModel.getColumn(4).setCellRenderer(this.level0);
                    break;
                }
                case 1: {
                    columnModel.getColumn(3).setCellRenderer(this.level1);
                    columnModel.getColumn(4).setCellRenderer(this.level1);
                    break;
                }
                case 2: {
                    columnModel.getColumn(3).setCellRenderer(this.level2);
                    columnModel.getColumn(4).setCellRenderer(this.level2);
                }
            }
            this.colorRenderer.setSupportLevel(supportLevel);
            this.fontRenderer.setSupportLevel(supportLevel);
            this.optionsTableModel.fireTableDataChanged();
        }
    }
}

