/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.colorfonteditor;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.view.SodukoConstants;
import de.gerdhirsch.soduko.view.ViewCellQuery;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRenderer0;
import de.gerdhirsch.soduko.view.options.CellViewOptionsModel;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.table.AbstractTableModel;

public class OptionsTableModel
extends AbstractTableModel
implements SodukoConstants,
LocalizeListener,
OptionsChangeListener {
    static final int KEY = 0;
    static final int NAME = 1;
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private CellRenderer0 renderer = null;
    private int supportLevel = 2;
    private ViewCellQuery[][] queries = new ViewCellQuery[][]{{new ViewCellQueryImpl(0, false, false, false, false, false, false), new ViewCellQueryImpl(0, false, false, false, false, false, false)}, {new ViewCellQueryImpl(0, false, false, false, false, false, false), new ViewCellQueryImpl(0, false, false, false, true, false, false)}, {new ViewCellQueryImpl(3, false, false, true, true, false, false), new ViewCellQueryImpl(4, false, false, true, true, false, false)}, {new ViewCellQueryImpl(5, true, false, true, false, false, false), new ViewCellQueryImpl(6, true, false, true, true, false, false)}, {new ViewCellQueryImpl(7, false, true, true, false, false, false), new ViewCellQueryImpl(8, false, true, true, true, false, false)}, {new ViewCellQueryImpl(9, false, false, true, false, false, false), new ViewCellQueryImpl(1, false, false, true, true, false, false)}, {new ViewCellQueryImpl(0, false, false, false, false, false, true), new ViewCellQueryImpl(0, false, false, false, true, false, true)}, {new ViewCellQueryImpl(2, false, false, false, false, false, false), new ViewCellQueryImpl(3, false, false, false, true, false, false)}, {new ViewCellQueryImpl(0, false, false, false, false, true, false), new ViewCellQueryImpl(0, false, false, false, true, true, false)}};
    private HashMap<String, CellViewOptionsModel> dataMap = null;
    private CellViewOptionsModel[][] data = new CellViewOptionsModel[][]{{new CellViewOptionsModel("Grid.Description", null, false), new CellViewOptionsModel("Grid.Color", null, true), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(this.queries[0][0], false), new CellViewOptionsModel(this.queries[0][1], false)}, {new CellViewOptionsModel("Nonfocus.Description", null, false), new CellViewOptionsModel("Nonfocus.Background", null, true), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(this.queries[1][0], false), new CellViewOptionsModel(this.queries[1][1], false)}, {new CellViewOptionsModel("Focus.Description", null, false), new CellViewOptionsModel("Focus.Background", null, true), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(this.queries[2][0], false), new CellViewOptionsModel(this.queries[2][1], false)}, {new CellViewOptionsModel("Givens.Description", null, false), new CellViewOptionsModel("Givens.Foreground", null, true), new CellViewOptionsModel("Givens.Font", null, true), new CellViewOptionsModel(this.queries[3][0], false), new CellViewOptionsModel(this.queries[3][1], false)}, {new CellViewOptionsModel("Fixed.Description", null, false), new CellViewOptionsModel("Values.Fixed.Foreground", null, true), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(this.queries[4][0], false), new CellViewOptionsModel(this.queries[4][1], false)}, {new CellViewOptionsModel("Valid.Description", null, false), new CellViewOptionsModel("Values.Valid.Foreground", null, true), new CellViewOptionsModel("Values.Font", null, true), new CellViewOptionsModel(this.queries[5][0], false), new CellViewOptionsModel(this.queries[5][1], false)}, {new CellViewOptionsModel("Memo.Description", null, false), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(this.queries[6][0], false), new CellViewOptionsModel(this.queries[6][1], false)}, {new CellViewOptionsModel("Invalid.Description", null, false), new CellViewOptionsModel("Values.Invalid.Foreground", null, true), new CellViewOptionsModel(null, null, false), new CellViewOptionsModel(this.queries[7][0], false), new CellViewOptionsModel(this.queries[7][1], false)}, {new CellViewOptionsModel("Possibility.Count.Description", null, false), new CellViewOptionsModel("Possiblity.Color", null, true), new CellViewOptionsModel("Possiblity.Font", null, true), new CellViewOptionsModel(this.queries[8][0], false), new CellViewOptionsModel(this.queries[8][1], false)}};

    public OptionsTableModel(LocalizeManager localizeManager, OptionsManager optionsManager, CellRenderer0 renderer) {
        this.localizeManager = localizeManager;
        this.optionsManager = optionsManager;
        this.renderer = renderer;
        localizeManager.addLocalizeListener(this);
        optionsManager.addOptionsChangeListener(this);
        this.dataMap = new HashMap();
        int row = 0;
        while (row < this.data.length) {
            int column = 1;
            while (column < 3) {
                this.dataMap.put(this.data[row][column].getKey(), this.data[row][column]);
                ++column;
            }
            ++row;
        }
        this.localizeView();
    }

    public int getColumnCount() {
        return this.data[0].length;
    }

    public int getRowCount() {
        return this.data.length;
    }

    public Object getValueAt(int row, int col) {
        return this.data[row][col].getValue();
    }

    public Class getColumnClass(int col) {
        return this.data[0][col].getValue().getClass();
    }

    public boolean isCellEditable(int row, int col) {
        return this.data[row][col].isEditable();
    }

    public void setValueAt(Object value, int row, int col) {
        this.optionsManager.putValue(this.data[row][col].getKey(), value);
    }

    public void localeChanged(EventObject event) {
        this.localizeView();
    }

    private void localizeView() {
        int column = 0;
        int row = 0;
        while (row < this.data.length) {
            String key = this.data[row][column].getKey();
            if (key != null) {
                this.data[row][column].setValue(this.localizeManager.getObject(this.data[row][column].getKey()));
                this.fireTableCellUpdated(row, column);
            }
            ++row;
        }
    }

    public void optionsChanged(OptionChangeEvent event) {
        CellViewOptionsModel cvom = null;
        Collection<String> keys = event.getKeys();
        for (String key : keys) {
            cvom = this.dataMap.get(key);
            if (cvom == null) continue;
            cvom.setValue(this.optionsManager.getValue(key));
        }
        this.fireTableDataChanged();
    }

    public void setSupportLevel(int supportLevel) {
        this.supportLevel = supportLevel;
        switch (supportLevel) {
            case 0: {
                this.data[7][1].setEditable(false);
                this.data[8][1].setEditable(false);
                this.data[8][2].setEditable(false);
                break;
            }
            case 1: {
                this.data[7][1].setEditable(true);
                this.data[8][1].setEditable(false);
                this.data[8][2].setEditable(false);
                break;
            }
            case 2: {
                this.data[7][1].setEditable(true);
                this.data[8][1].setEditable(true);
                this.data[8][2].setEditable(true);
            }
        }
        this.fireTableDataChanged();
    }

    public class ViewCellQueryImpl
    implements ViewCellQuery {
        private boolean isGiven = false;
        private boolean isFixed = false;
        private boolean isValid = false;
        private int symbol = 5;
        private boolean wasLastSelected = false;
        private int[] possibilities = new int[]{1, 5, 6, 9};
        private boolean hasPossibilities = false;
        private boolean[] memos;
        private boolean[] memosValid;
        private boolean hasMemos;

        public ViewCellQueryImpl(int symbol, boolean isGiven, boolean isFixed, boolean isValid, boolean wasLastSelected, boolean hasPossibilities, boolean hasMemos) {
            boolean[] blArray = new boolean[9];
            blArray[0] = true;
            blArray[1] = true;
            blArray[4] = true;
            blArray[5] = true;
            blArray[6] = true;
            blArray[8] = true;
            this.memos = blArray;
            boolean[] blArray2 = new boolean[9];
            blArray2[0] = true;
            blArray2[1] = true;
            blArray2[5] = true;
            blArray2[8] = true;
            this.memosValid = blArray2;
            this.hasMemos = false;
            this.symbol = symbol;
            this.isGiven = isGiven;
            this.isFixed = isFixed;
            this.isValid = isValid;
            this.wasLastSelected = wasLastSelected;
            this.hasPossibilities = hasPossibilities;
            this.hasMemos = hasMemos;
        }

        public void setCellQuery(CellQuery selectedCell) {
        }

        public void setLastSelected(boolean lastSelected) {
            this.wasLastSelected = lastSelected;
        }

        public boolean wasLastSelected() {
            return this.wasLastSelected;
        }

        public boolean isPossible(int symbol) {
            return this.memosValid[symbol - 1];
        }

        public boolean isValid() {
            return this.isValid;
        }

        public boolean isGiven() {
            return this.isGiven;
        }

        public boolean isMemo(int symbol) throws RegelverletzungException {
            return this.memos[symbol - 1];
        }

        public boolean isFixed() {
            return this.isFixed;
        }

        public int getSymbolMask() {
            return 0;
        }

        public int getMask() {
            return 0;
        }

        public int[] getPossibilities() {
            return this.possibilities;
        }

        public int getSymbol() {
            return this.symbol;
        }

        public boolean[] getMemos() {
            return this.memos;
        }

        public void setSymbol(int symbol) {
            this.symbol = symbol;
        }

        public void setFixed(boolean isFixed) {
            this.isFixed = isFixed;
        }

        public void setGiven(boolean isGiven) {
            this.isGiven = isGiven;
        }

        public void setValid(boolean isValid) {
            this.isValid = isValid;
        }

        public void setPossibilities(int[] possibilities) {
            this.possibilities = possibilities;
        }

        public boolean isHasMemos() {
            return this.hasMemos;
        }

        public void setHasMemos(boolean hasMemos) {
            this.hasMemos = hasMemos;
        }

        public boolean isHasPossibilities() {
            return this.hasPossibilities;
        }

        public void setHasPossibilities(boolean hasPossibilities) {
            this.hasPossibilities = hasPossibilities;
        }
    }
}

