/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.manager;

import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerImpl;
import java.util.Collection;

public class OptionsManagerDialog
extends OptionsManagerImpl {
    private OptionsManager optionsManager = null;
    private OptionChangeEvent dialogEvent = null;

    public OptionsManagerDialog(OptionsManager optionsManager) {
        super(optionsManager.getDefaults());
        this.optionsManager = optionsManager;
        this.dialogEvent = new OptionChangeEvent(this);
        this.copyOptions();
    }

    private void copyOptions() {
        Collection<String> keys = this.optionsManager.getKeys();
        for (String key : keys) {
            super.putValue(key, this.optionsManager.getValue(key));
        }
        this.event.clearKeys();
    }

    public void putValue(String key, Object newValue) {
        super.putValue(key, newValue);
        this.dialogEvent.keyChanged(key);
        this.fireOptionsChanged(this.dialogEvent);
    }

    public void apply() {
        Collection<String> keys = this.event.getKeys();
        for (String key : keys) {
            this.optionsManager.putValue(key, this.getValue(key));
        }
        this.optionsManager.apply();
    }

    public Object clone() throws CloneNotSupportedException {
        OptionsManagerDialog retVal = (OptionsManagerDialog)super.clone();
        retVal.dialogEvent = (OptionChangeEvent)this.dialogEvent.clone();
        retVal.dialogEvent.setOptionsManager(retVal);
        return retVal;
    }
}

