/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.manager;

import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import java.awt.Color;
import java.awt.Font;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionsManagerImpl
implements OptionsManager,
Cloneable {
    protected HashMap<String, Object> options = new HashMap();
    protected HashMap<String, Object> defaults = null;
    protected transient HashMap<OptionsChangeListener, OptionsChangeListener> listeners = new HashMap();
    protected transient OptionChangeEvent event = new OptionChangeEvent(this);

    public OptionsManagerImpl(HashMap<String, Object> defaults) {
        this();
        this.defaults = defaults;
    }

    public OptionsManagerImpl() {
    }

    @Override
    public void putValue(String key, Object newValue) {
        Object oldValue = this.getValue(key);
        if (oldValue == null || !oldValue.equals(newValue)) {
            this.options.put(key, newValue);
            if (this.event == null) {
                this.event = new OptionChangeEvent(this);
            }
            this.event.keyChanged(key);
        }
    }

    @Override
    public Object getValue(String key) {
        Object retVal = this.options.get(key);
        if (retVal == null && this.defaults != null) {
            retVal = this.defaults.get(key);
        }
        return retVal;
    }

    @Override
    public String getString(String key) {
        Object value = this.getValue(key);
        String retVal = null;
        if (value != null && value instanceof String) {
            retVal = (String)value;
        }
        return retVal;
    }

    @Override
    public Object getDefaultValue(String key) {
        Object retVal = null;
        if (this.defaults != null) {
            retVal = this.defaults.get(key);
        }
        return retVal;
    }

    @Override
    public void addOptionsChangeListener(OptionsChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.put(listener, listener);
    }

    @Override
    public void removeOptionsChangeListener(OptionsChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void apply() {
        if (this.event == null) {
            return;
        }
        if (!this.event.getKeys().isEmpty()) {
            this.fireOptionsChanged(this.event);
        }
    }

    protected void fireOptionsChanged(OptionChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        Collection<OptionsChangeListener> values = this.listeners.values();
        for (OptionsChangeListener listener : values) {
            listener.optionsChanged(event);
        }
        event.clearKeys();
    }

    @Override
    public Collection<String> getKeys() {
        TreeSet<String> retVal = null;
        if (this.defaults != null) {
            retVal = new TreeSet();
            Collection keys = this.defaults.keySet();
            for (String key : keys) {
                retVal.add(key);
            }
            keys = this.options.keySet();
            for (String key : keys) {
                retVal.add(key);
            }
        } else {
            retVal = this.options.keySet();
        }
        return retVal;
    }

    @Override
    public Integer getInteger(String key) {
        Object value = this.getValue(key);
        Integer retVal = null;
        if (value != null && value instanceof Integer) {
            retVal = (Integer)value;
        }
        return retVal;
    }

    @Override
    public Font getFont(String key) {
        Object value = this.getValue(key);
        Font retVal = null;
        if (value != null && value instanceof Font) {
            retVal = (Font)value;
        }
        return retVal;
    }

    @Override
    public Color getColor(String key) {
        Object value = this.getValue(key);
        Color retVal = null;
        if (value != null && value instanceof Color) {
            retVal = (Color)value;
        }
        return retVal;
    }

    @Override
    public Locale getLocale(String key) {
        Object value = this.getValue(key);
        Locale retVal = null;
        if (value != null && value instanceof Locale) {
            retVal = (Locale)value;
        }
        return retVal;
    }

    @Override
    public void updateAllKeys() {
        if (this.event == null) {
            this.event = new OptionChangeEvent(this);
        }
        Collection<String> keys = this.getKeys();
        for (String key : keys) {
            this.event.keyChanged(key);
        }
        this.fireOptionsChanged(this.event);
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        OptionsManagerImpl retVal = (OptionsManagerImpl)super.clone();
        if (this.defaults != null) {
            retVal.defaults = (HashMap)this.defaults.clone();
        }
        retVal.options = (HashMap)this.options.clone();
        retVal.event = (OptionChangeEvent)this.event.clone();
        retVal.event.setOptionsManager(retVal);
        return retVal;
    }

    @Override
    public void restoreDefaults() {
        Collection keys = this.options.keySet();
        Object value = null;
        for (String key : keys) {
            value = this.defaults.get(key);
            if (value == null) continue;
            this.putValue(key, value);
        }
        this.fireOptionsChanged(this.event);
    }

    @Override
    public HashMap<String, Object> getDefaults() {
        return this.defaults;
    }
}

