/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.manager;

import de.gerdhirsch.soduko.model.SudokuFactory;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerPointer;
import de.gerdhirsch.soduko.view.options.manager.PutValue;
import de.gerdhirsch.util.undoredo.CommandComposite;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;
import java.util.Collection;

public class OptionsManagerUndoRedoable
extends OptionsManagerPointer
implements Cloneable {
    private UndoRedoHandler urha = null;

    public OptionsManagerUndoRedoable(OptionsManager optionsManager, UndoRedoHandler urha) {
        super(optionsManager);
        this.urha = urha;
    }

    public void putValue(String key, Object newValue) {
        Object oldValue = this.optionsManager.getValue(key);
        if (oldValue == null || !oldValue.equals(newValue)) {
            PutValue command = new PutValue(this.optionsManager, key, oldValue, newValue);
            try {
                this.urha.doIt(command);
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                e.printStackTrace();
            }
        }
    }

    public void restoreDefaults() {
        Collection<String> keys = this.getKeys();
        Object oldValue = null;
        Object newValue = null;
        PutValue command = null;
        UndoRedoHandler ccUrha = SudokuFactory.getFactory().createUndoRedoHandler();
        CommandComposite cc = new CommandComposite(ccUrha);
        try {
            for (String key : keys) {
                oldValue = this.getValue(key);
                newValue = this.getDefaultValue(key);
                if (newValue == null || oldValue != null && oldValue.equals(newValue)) continue;
                command = new PutValue(this.optionsManager, key, oldValue, newValue);
                cc.doIt(command);
            }
            this.urha.doIt(cc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UndoRedoHandler getUndoRedoHandler() {
        return this.urha;
    }

    public Object clone() throws CloneNotSupportedException {
        OptionsManagerUndoRedoable retVal = (OptionsManagerUndoRedoable)super.clone();
        retVal.optionsManager = (OptionsManager)this.optionsManager.clone();
        PutValue.setClonedManager(retVal.optionsManager);
        retVal.urha = (UndoRedoHandler)this.urha.clone();
        return retVal;
    }
}

