/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.test;

import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.options.manager.OptionsManagerImpl;
import java.util.Collection;
import java.util.HashMap;
import junit.framework.TestCase;

public class OptionsManagerBasisTest
extends TestCase {
    final String VALUE_1 = "Value.1";
    final String VALUE_2 = "Value.2";
    final String VALUE_3 = "Value.3";
    final String VALUE_4 = "Value.4";
    protected OptionsManager expectedManager = null;
    protected OptionsManager appOptionsManager = null;
    protected Listener appOptionsListener = new Listener();
    protected Listener testListener = new Listener();

    protected void setUp() throws Exception {
        super.setUp();
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("Value.1", 1);
        defaults.put("Value.2", 2);
        this.appOptionsManager = new OptionsManagerImpl(defaults);
        this.appOptionsManager.putValue("Value.2", 5);
        this.appOptionsManager.putValue("Value.3", 3);
        defaults = new HashMap();
        defaults.put("Value.1", 1);
        defaults.put("Value.2", 2);
        defaults.put("Value.3", 3);
        this.expectedManager = new OptionsManagerImpl(defaults);
        this.expectedManager.putValue("Value.2", 5);
        this.expectedManager.putValue("Value.3", 3);
        this.expectedManager.putValue("Value.4", 4);
    }

    protected void putValue(String key, Object value, OptionsManager om) {
        this.expectedManager.putValue(key, value);
        om.putValue(key, value);
    }

    class Listener
    implements OptionsChangeListener {
        private boolean wasCalled;

        Listener() {
        }

        public boolean wasCalled() {
            boolean retVal = this.wasCalled;
            this.wasCalled = false;
            return retVal;
        }

        public void optionsChanged(OptionChangeEvent event) {
            this.wasCalled = true;
            OptionsManager om = (OptionsManager)event.getSource();
            String className = om.getClass().getName();
            Object expected = null;
            Object test = null;
            Collection<String> keysExpected = OptionsManagerBasisTest.this.expectedManager.getKeys();
            Collection<String> keysTest = om.getKeys();
            for (String key : keysTest) {
                expected = OptionsManagerBasisTest.this.expectedManager.getValue(key);
                test = om.getValue(key);
                OptionsManagerBasisTest.assertEquals((String)(String.valueOf(key) + ":" + className), (Object)expected, (Object)test);
            }
        }
    }
}

