/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.options.test;

import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.options.test.OptionsManagerBasisTest;
import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.Collection;

public class OptionsManagerSerializableTest
extends OptionsManagerBasisTest {
    String optionsFileName = null;

    protected void setUp() throws Exception {
        super.setUp();
        URL fileURL = ((Object)((Object)this)).getClass().getResource("/de/gerdhirsch/soduko/view/options/test");
        this.optionsFileName = fileURL.toString();
        int posFirstSlash = this.optionsFileName.indexOf(47);
        this.optionsFileName = this.optionsFileName.substring(posFirstSlash + 1);
        this.optionsFileName = this.optionsFileName.replace('/', File.separatorChar);
        this.optionsFileName = String.valueOf(this.optionsFileName) + File.separatorChar + "TestOptions.opt";
    }

    public void testSerialize() {
        this.appOptionsManager.addOptionsChangeListener(this.appOptionsListener);
        this.putValue("String", "testValue", this.appOptionsManager);
        this.putValue("Font", new Font("Impact", 0, 20), this.appOptionsManager);
        this.putValue("Color", Color.BLACK, this.appOptionsManager);
        this.appOptionsManager.apply();
        OptionsManagerSerializableTest.assertTrue((boolean)this.appOptionsListener.wasCalled());
        try {
            FileOutputStream fos = new FileOutputStream(this.optionsFileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(this.appOptionsManager);
            oos.close();
            fos.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            OptionsManagerSerializableTest.assertFalse((boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
            OptionsManagerSerializableTest.assertFalse((boolean)true);
        }
        File usrOptionsFile = new File(this.optionsFileName);
        OptionsManagerSerializableTest.assertTrue((boolean)usrOptionsFile.exists());
        OptionsManager loadedManager = null;
        try {
            FileInputStream fis = new FileInputStream(this.optionsFileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            loadedManager = (OptionsManager)ois.readObject();
            loadedManager.addOptionsChangeListener(this.appOptionsListener);
            loadedManager.apply();
            OptionsManagerSerializableTest.assertFalse((boolean)this.appOptionsListener.wasCalled());
            loadedManager.updateAllKeys();
            OptionsManagerSerializableTest.assertTrue((boolean)this.appOptionsListener.wasCalled());
            fis.close();
            ois.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            OptionsManagerSerializableTest.assertFalse((boolean)true);
        }
        catch (IOException e) {
            e.printStackTrace();
            OptionsManagerSerializableTest.assertFalse((boolean)true);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            OptionsManagerSerializableTest.assertFalse((boolean)true);
        }
        Collection<String> keys = this.appOptionsManager.getKeys();
        for (String key : keys) {
            OptionsManagerSerializableTest.assertEquals((Object)this.appOptionsManager.getValue(key), (Object)loadedManager.getValue(key));
        }
    }
}

