/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabmemo;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.view.CellRenderer;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.tabmemo.MemoLabel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JTable;

public class MemoCellRenderer
extends CellRenderer {
    protected JLabel memoLabel = null;

    public MemoCellRenderer(OptionsManager om) {
        super(om);
        this.add((Component)this.createMemoLabel(), JLayeredPane.DEFAULT_LAYER);
    }

    public Component getTableCellRendererComponent(JTable table, Object cell, boolean isSelected, boolean hasFocus, int row, int column) {
        this.setOpaque(true);
        if (hasFocus) {
            this.setBackground(this.focusBackgroundColor);
        } else {
            this.setBackground(this.nonFocusBackgroundColor);
        }
        CellQuery cellquery = (CellQuery)cell;
        boolean isSet = false;
        if (cellquery != null) {
            try {
                isSet = cellquery.isMemo(this.getResponsibleValue(row, column));
            }
            catch (RegelverletzungException e) {
                e.printStackTrace();
            }
        }
        if (isSet) {
            this.memoLabel.setForeground(this.valuesValidForeground);
        } else if (hasFocus) {
            this.memoLabel.setForeground(this.focusBackgroundColor);
            this.memoLabel.setBackground(this.focusBackgroundColor);
        } else {
            this.memoLabel.setForeground(this.nonFocusBackgroundColor);
            this.memoLabel.setBackground(this.nonFocusBackgroundColor);
        }
        return this;
    }

    protected int getResponsibleValue(int row, int column) {
        return row * 3 + column + 1;
    }

    protected JComponent createMemoLabel() {
        int xPos = 0;
        int yPos = 0;
        int width = 30;
        int height = 30;
        JLabel retVal = null;
        this.memoLabel = new MemoLabel();
        this.memoLabel.setBounds(xPos, yPos, width, height);
        retVal = this.memoLabel;
        return retVal;
    }
}

