/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabmemo;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.tabmemo.MemoCellRendererLevel1;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public class MemoSuggestionCellRenderer
extends MemoCellRendererLevel1
implements TableCellRenderer {
    private Font suggestionFont = null;
    private Color suggestionColor = null;
    private JLabel suggestionLabel = null;

    public MemoSuggestionCellRenderer(OptionsManager om) {
        super(om);
        this.configureMemoSuggestionRenderer(null);
        this.add((Component)this.createSuggestionLabel(), JLayeredPane.PALETTE_LAYER);
    }

    public Component getTableCellRendererComponent(JTable table, Object cell, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, cell, isSelected, hasFocus, row, column);
        if (cell != null) {
            CellQuery zellquery = (CellQuery)cell;
            int[] vorgaben = zellquery.getPossibilities();
            String suggestionValue = "";
            int expected = this.getResponsibleValue(row, column);
            if (vorgaben != null) {
                int i = 0;
                while (i < expected && i < vorgaben.length) {
                    if (vorgaben[i] == expected) {
                        suggestionValue = " " + expected;
                        break;
                    }
                    ++i;
                }
            }
            this.suggestionLabel.setText(suggestionValue);
        }
        return this;
    }

    protected JComponent createSuggestionLabel() {
        int xPos = 2;
        int yPos = 2;
        int width = 10;
        int height = 10;
        this.suggestionLabel = new JLabel();
        this.suggestionLabel.setBounds(xPos, yPos, width, height);
        this.suggestionLabel.setFont(this.suggestionFont);
        this.suggestionLabel.setForeground(this.suggestionColor);
        return this.suggestionLabel;
    }

    public void optionsChanged(OptionChangeEvent event) {
        super.optionsChanged(event);
        this.configureMemoSuggestionRenderer(event);
    }

    public final void configureMemoSuggestionRenderer(OptionChangeEvent event) {
        Font font;
        Color color;
        if ((event == null || event.isChanged("Suggestion.Color")) && (color = this.optionsManager.getColor("Suggestion.Color")) != null) {
            this.suggestionColor = color;
            if (this.suggestionLabel != null) {
                this.suggestionLabel.setForeground(this.suggestionColor);
            }
        }
        if ((event == null || event.isChanged("Suggestion.Font")) && (font = this.optionsManager.getFont("Suggestion.Font")) != null) {
            this.suggestionFont = font;
            if (this.suggestionLabel != null) {
                this.suggestionLabel.setFont(this.suggestionFont);
            }
        }
    }
}

