/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabmemo;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.RegelverletzungException;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import javax.swing.table.AbstractTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoTableModel
extends AbstractTableModel
implements SudokuListener {
    private int sodukoRow = -1;
    private int sodukoColumn = -1;
    private CellQuery cell = null;
    private Game game = null;
    static /* synthetic */ Class class$0;

    @Override
    public int getRowCount() {
        return 3;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    public void clear() {
        this.cell = null;
        this.sodukoRow = -1;
        this.sodukoColumn = -1;
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        if (this.cell != null) {
            return !this.cell.isGiven();
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.cell;
    }

    @Override
    public void setValueAt(Object UNUSED, int row, int column) {
        if (this.cell == null) {
            return;
        }
        if (this.cell.isGiven()) {
            return;
        }
        int value = 1 + row * 3 + column;
        try {
            this.game.setMemo(this.sodukoRow, this.sodukoColumn, value, !this.cell.isMemo(value));
        }
        catch (RegelverletzungException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void fireTableDataChanged() {
        int row = 0;
        while (row < 3) {
            int column = 0;
            while (column < 3) {
                this.fireTableCellUpdated(row, column);
                ++column;
            }
            ++row;
        }
    }

    public void setGame(Game game) {
        this.game = game;
        game.addSudokuListener(this);
    }

    @Override
    public void spielfeldChanged(SudokuEvent event) {
        this.fireTableDataChanged();
    }

    public void setCell(int sodukoRow, int sodukoColumn, CellQuery cell) {
        this.sodukoRow = sodukoRow;
        this.sodukoColumn = sodukoColumn;
        this.cell = cell;
        this.fireTableDataChanged();
    }
}

