/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabmemo;

import de.gerdhirsch.soduko.model.CellQuery;
import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.soduko.view.OptionsPanel;
import de.gerdhirsch.soduko.view.game.CellChangeEvent;
import de.gerdhirsch.soduko.view.game.cellrenderer.CellRendererListener;
import de.gerdhirsch.soduko.view.options.manager.OptionChangeEvent;
import de.gerdhirsch.soduko.view.options.manager.OptionsChangeListener;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.tabmemo.MemoCellRenderer;
import de.gerdhirsch.soduko.view.tabmemo.MemoCellRendererLevel1;
import de.gerdhirsch.soduko.view.tabmemo.MemoSuggestionCellRenderer;
import de.gerdhirsch.soduko.view.tabmemo.MemoTableModel;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelEvent;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelListener;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.IOException;
import java.net.URL;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class TabMemo
extends OptionsPanel
implements SudokuListener,
OptionsChangeListener,
SupportLevelListener,
LocalizeListener,
CellRendererListener {
    public static final int CELLDIMENSION = 30;
    public static final int COLUMNCOUNT = 3;
    public static final int LEFTMARGIN = 15;
    public static final int TOPMARGIN = 15;
    public static final int XPOSTABLE = 20;
    public static final int YPOSTABLE = 20;
    public static final int X_Y_POSMIN = 1;
    public static final int MINWIDTH = 110;
    public static final int MIN_DIMENSION = 92;
    public static final int CHECKBOX_HEIGHT = 25;
    public static final int TABLEDIMENSION = 90;
    public static final int YPOSTEXT = 150;
    public static final int TEXTHEIGHT = 200;
    public static final int TEXTWIDTH = 300;
    private int supportLevel = -1;
    private Game game = null;
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private JCheckBox fixedCheckBox = null;
    private JEditorPane helpTextMemo = null;
    private JScrollPane helpScroller = null;
    private int selectedSodukoRow = 0;
    private int selectedSodukoColumn = 0;
    private CellQuery selectedCell = null;
    private KeyListener blankListener = new BlankListener();
    private DefaultTableColumnModel memoColumnModel = null;
    private MemoTableModel memoTableModel = null;
    private JTable memoTable = null;
    private MemoCellRenderer memoCellRenderer = null;
    private MemoCellRenderer memoCellRendererLevel1 = null;
    private MemoSuggestionCellRenderer suggestionCellRenderer = null;
    private MemoCellRenderer[] cellRenderer = null;

    public TabMemo(Game game, LocalizeManager lm, OptionsManager optionsManager) {
        this.optionsManager = optionsManager;
        this.localizeManager = lm;
        this.game = game;
        this.game.addSudokuListener(this);
        this.optionsManager.addOptionsChangeListener(this);
        this.localizeManager.addLocalizeListener(this);
        this.supportLevel = optionsManager.getInteger("Default.Supportlevel");
        this.memoCellRenderer = new MemoCellRenderer(this.optionsManager);
        this.memoCellRendererLevel1 = new MemoCellRendererLevel1(this.optionsManager);
        this.suggestionCellRenderer = new MemoSuggestionCellRenderer(this.optionsManager);
        this.cellRenderer = new MemoCellRenderer[]{this.memoCellRenderer, this.memoCellRendererLevel1, this.memoCellRendererLevel1, this.suggestionCellRenderer, this.suggestionCellRenderer, this.suggestionCellRenderer, this.suggestionCellRenderer};
        this.createTabMemo();
    }

    public String getResourceKey() {
        return "TabMemo";
    }

    public MemoTableModel getTableModel() {
        return this.memoTableModel;
    }

    public void supportLevelChanged(SupportLevelEvent event) {
        this.supportLevel = event.getSupportLevel();
        TableColumn col = null;
        int COUNT = this.memoColumnModel.getColumnCount();
        int i = 0;
        while (i < COUNT) {
            col = this.memoColumnModel.getColumn(i);
            col.setCellRenderer(this.cellRenderer[this.supportLevel]);
            ++i;
        }
        this.memoTableModel.fireTableDataChanged();
    }

    public void localeChanged(EventObject event) {
        this.localizeView();
    }

    protected void createTabMemo() {
        this.memoTableModel = new MemoTableModel();
        this.memoTableModel.setGame(this.game);
        int defaultSupportLevel = this.optionsManager.getInteger("Default.Supportlevel");
        this.memoColumnModel = new DefaultTableColumnModel();
        int i = 0;
        while (i < 3) {
            TableColumn col = new TableColumn(i, 30);
            col.setCellRenderer(this.cellRenderer[defaultSupportLevel]);
            this.memoColumnModel.addColumn(col);
            ++i;
        }
        this.memoTable = new JTable(this.memoTableModel, this.memoColumnModel);
        this.memoTable.setRowHeight(30);
        this.memoTable.setBackground(Color.WHITE);
        this.memoTable.setBounds(20, 20, 90, 90);
        this.memoTable.setGridColor(Color.BLACK);
        this.memoTable.setBorder(LineBorder.createBlackLineBorder());
        this.memoTable.setCellSelectionEnabled(false);
        this.memoTable.addKeyListener(this.blankListener);
        this.helpTextMemo = new JEditorPane();
        this.helpTextMemo.setEditable(false);
        this.helpTextMemo.setOpaque(false);
        this.helpTextMemo.setBackground(Color.LIGHT_GRAY);
        this.helpScroller = new JScrollPane(this.helpTextMemo);
        this.helpScroller.setVerticalScrollBarPolicy(20);
        this.helpScroller.setHorizontalScrollBarPolicy(30);
        this.helpScroller.setBounds(5, 150, 300, 200);
        this.helpScroller.setOpaque(false);
        this.helpScroller.setBackground(Color.LIGHT_GRAY);
        this.fixedCheckBox = new JCheckBox();
        this.fixedCheckBox.setOpaque(false);
        this.fixedCheckBox.setVisible(true);
        this.fixedCheckBox.setSelected(false);
        this.fixedCheckBox.setEnabled(false);
        this.fixedCheckBox.addActionListener(new CheckBoxListener());
        this.localizeView();
        this.add((Component)this.memoTable, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.helpScroller, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.fixedCheckBox, JLayeredPane.DEFAULT_LAYER);
    }

    protected void componentResized(ComponentEvent event) {
        Dimension preferredSize = new Dimension(92, 92);
        Component component = event.getComponent();
        int width = component.getWidth() - 10;
        int height = component.getHeight() - 15;
        this.helpScroller.setBounds(5, 150, width, height - 150);
        this.fixedCheckBox.setBounds(5, 120, width, 25);
        if (width < 110 && width > -5) {
            this.memoTable.setBounds(1, 1, 90, 90);
            component.setMinimumSize(preferredSize);
        } else if (width > 110) {
            this.memoTable.setBounds(20, 20, 90, 90);
        }
    }

    private void localizeView() {
        URL helpURL = this.localizeManager.getResource(this, "/de/gerdhirsch/soduko/view/resources/MemoHelp.html");
        this.fixedCheckBox.setText(this.localizeManager.getString("TabMemo.Fixed.CheckBox"));
        if (helpURL != null) {
            try {
                this.helpTextMemo.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
                e.printStackTrace();
            }
        } else {
            System.err.println("Resource not found: /de/gerdhirsch/soduko/view/resources/MemoHelp.html");
        }
    }

    private void checkViewState() {
        if (this.supportLevel < 1) {
            if (this.selectedCell.isGiven() || this.selectedCell.getSymbol() == 0) {
                this.fixedCheckBox.setEnabled(false);
            } else {
                this.fixedCheckBox.setEnabled(true);
            }
        } else if (this.selectedCell.isGiven() || !this.selectedCell.isValid() && !this.selectedCell.isFixed()) {
            this.fixedCheckBox.setEnabled(false);
        } else {
            this.fixedCheckBox.setEnabled(true);
        }
    }

    public void toggleFixed() {
        if (this.fixedCheckBox.isEnabled()) {
            boolean fixed = !this.game.isFixed(this.selectedSodukoRow, this.selectedSodukoColumn);
            this.game.setFixed(this.selectedSodukoRow, this.selectedSodukoColumn, fixed);
        } else {
            this.getToolkit().beep();
        }
    }

    public void cellChanged(CellChangeEvent event) {
        this.selectedSodukoRow = event.getRow();
        this.selectedSodukoColumn = event.getColumn();
        this.updateMemoTable(this.selectedSodukoRow, this.selectedSodukoColumn);
    }

    public void spielfeldChanged(SudokuEvent event) {
        this.selectedSodukoRow = event.getZeile();
        this.selectedSodukoColumn = event.getSpalte();
        this.updateMemoTable(this.selectedSodukoRow, this.selectedSodukoColumn);
    }

    protected void updateMemoTable(int row, int col) {
        this.selectedCell = this.game.getZelle(this.selectedSodukoRow, this.selectedSodukoColumn);
        this.fixedCheckBox.setSelected(this.selectedCell.isFixed());
        this.memoTableModel.setCell(this.selectedSodukoRow, this.selectedSodukoColumn, this.selectedCell);
        this.checkViewState();
    }

    public void optionsChanged(OptionChangeEvent event) {
        this.memoTableModel.fireTableDataChanged();
    }

    public class BlankListener
    extends KeyAdapter {
        public void keyTyped(KeyEvent event) {
            int row = TabMemo.this.memoTable.getSelectedRow();
            int column = TabMemo.this.memoTable.getSelectedColumn();
            if (!TabMemo.this.memoTable.isCellEditable(row, column)) {
                return;
            }
            char keyChar = event.getKeyChar();
            if (keyChar == ' ') {
                TabMemo.this.memoTable.setValueAt(null, row, column);
            }
        }
    }

    class CheckBoxListener
    extends AbstractAction {
        CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent event) {
            TabMemo.this.game.setFixed(TabMemo.this.selectedSodukoRow, TabMemo.this.selectedSodukoColumn, TabMemo.this.fixedCheckBox.isSelected());
        }
    }
}

