/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabstatistic;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.view.OptionsPanel;
import de.gerdhirsch.soduko.view.tabstatistic.TabStatisticTableModel;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URL;
import java.util.EventObject;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;

public class TabStatistic
extends OptionsPanel
implements LocalizeListener {
    public static final int STATISTICCOLUMN_DESCRIPTION_MAXWIDTH = 200;
    public static final int STATISTICCOLUMN_VALUES_MAXWIDTH = 300;
    public static final int COLUMNDEFAULTWIDTH = 140;
    public static final int COLUMNMINWIDTH = 50;
    public static final int COLUMNCOUNT = 2;
    public static final int STATISTIC_ROWHEIGHT = 20;
    private Game game = null;
    private JTable statisticTable = null;
    private TabStatisticTableModel statisticTableModel = null;
    private DefaultTableColumnModel statisticColumnModel = null;
    private JEditorPane helpTextStatistic = null;
    private JScrollPane helpScroller = null;
    private LocalizeManager localizeManager = null;

    public TabStatistic(Game game, LocalizeManager localizeManager) {
        this.game = game;
        this.localizeManager = localizeManager;
        localizeManager.addLocalizeListener(this);
        this.createStatistikTab();
    }

    public String getResourceKey() {
        return "TabStatistic";
    }

    public void localeChanged(EventObject event) {
        this.localizeTabStatistic();
    }

    protected void createStatistikTab() {
        this.statisticTableModel = new TabStatisticTableModel(this.game, this.localizeManager);
        this.statisticColumnModel = new DefaultTableColumnModel();
        int column = 0;
        while (column < 2) {
            TableColumn col = new TableColumn(column, 140);
            if (column == 0) {
                col.setMaxWidth(200);
            } else {
                col.setMaxWidth(300);
            }
            col.setMinWidth(50);
            this.statisticColumnModel.addColumn(col);
            ++column;
        }
        this.statisticTable = new JTable(this.statisticTableModel, this.statisticColumnModel);
        this.statisticTable.setBackground(Color.LIGHT_GRAY);
        this.statisticTable.setCellSelectionEnabled(false);
        this.statisticTable.setOpaque(false);
        this.helpTextStatistic = new JEditorPane();
        this.helpTextStatistic.setEditable(false);
        this.helpTextStatistic.setOpaque(false);
        this.helpTextStatistic.setBackground(Color.LIGHT_GRAY);
        this.helpScroller = new JScrollPane(this.helpTextStatistic);
        this.helpScroller.setVerticalScrollBarPolicy(20);
        this.helpScroller.setHorizontalScrollBarPolicy(30);
        this.helpScroller.setOpaque(false);
        this.helpScroller.setBackground(Color.LIGHT_GRAY);
        this.localizeTabStatistic();
        this.add((Component)this.statisticTable, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.helpScroller, JLayeredPane.PALETTE_LAYER);
    }

    protected void componentResized(ComponentEvent event) {
        Component component = event.getComponent();
        int width = component.getWidth() - 10;
        int height = component.getHeight() - 20;
        int rows = this.statisticTable.getRowCount();
        this.statisticTable.setBounds(5, 5, width, 20 * rows);
        int tableHeight = this.statisticTable.getHeight();
        this.helpScroller.setBounds(5, 5 + tableHeight, width, height - tableHeight);
    }

    private void localizeTabStatistic() {
        String resource = "/de/gerdhirsch/soduko/view/resources/StatisticHelp.html";
        URL helpURL = this.localizeManager.getResource(this, resource);
        if (helpURL != null) {
            try {
                this.helpTextStatistic.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
                e.printStackTrace();
            }
        } else {
            System.err.println("Resource not found: " + resource);
        }
    }
}

