/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabstatistic;

import de.gerdhirsch.soduko.model.Game;
import de.gerdhirsch.soduko.model.SudokuEvent;
import de.gerdhirsch.soduko.model.SudokuListener;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EventObject;
import javax.swing.table.AbstractTableModel;

public class TabStatisticTableModel
extends AbstractTableModel
implements LocalizeListener,
SudokuListener {
    private int[] fixedCount = new int[9];
    static final int FREQUENCY = 0;
    static final int SYMBOL = 1;
    Comparator<int[]> frequencyComparator = new Comparator<int[]>(){

        @Override
        public int compare(int[] o1, int[] o2) {
            return o2[0] - o1[0];
        }
    };
    private Game game = null;
    private LocalizeManager localizeManager = null;
    private static final int LABEL = 0;
    private static final int VALUE = 1;
    private static final int KEY = 2;
    private static final int SEVERITY = 0;
    private static final int NUMBEROFGIVENS = 1;
    private static final int MINIMUM = 2;
    private static final int POSSIBILITIES = 3;
    private static final int SYMBOL_FREQUENCY = 4;
    private static final int SYMBOL_FREQUENCY_FIXED = 5;
    private String[][] rowLabels = new String[][]{{"Schwierigkeitsgrad:", "TODO", "TabStatistic.Severity"}, {"Anzahl Givens", "TODO", "TabStatistic.NumberOfGivens"}, {"Minimum ", "TODO", "TabStatistic.Minimum"}, {"M\u00f6glichkeiten / Felder", "TODO", "TabStatistic.Possibilities"}, {"H\u00e4ufigkeit / Symbol ", "TODO", "TabStatistic.SymbolFrequency"}, {"H\u00e4ufigkeit + Fixed / Symbol ", "TODO", "TabStatistic.SymbolFrequency.Fixed"}};

    public TabStatisticTableModel(Game game, LocalizeManager lm) {
        this.game = game;
        this.localizeManager = lm;
        this.localizeManager.addLocalizeListener(this);
        this.game.addSudokuListener(this);
        this.configureTable();
    }

    public int getRowCount() {
        return this.rowLabels.length;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int zeile, int spalte) {
        return this.rowLabels[zeile][spalte];
    }

    public int[] getSuggestionsCountPerCell() {
        return null;
    }

    public void localeChanged(EventObject event) {
        this.configureTable();
    }

    protected void configureTable() {
        this.computeStatistic();
        int i = 0;
        while (i < this.rowLabels.length) {
            this.rowLabels[i][0] = this.localizeManager.getString(this.rowLabels[i][2]);
            ++i;
        }
        this.fireTableDataChanged();
    }

    public void spielfeldChanged(SudokuEvent event) {
        this.computeDynamicStatistic();
        this.fireTableDataChanged();
    }

    private void computeStatistic() {
        this.computeStaticStatistic();
        this.computeDynamicStatistic();
        this.fireTableDataChanged();
    }

    protected void computeDynamicStatistic() {
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 4;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[1] = 5;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 6;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = 7;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[1] = 8;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[2];
        nArray9[1] = 9;
        nArrayArray[8] = nArray9;
        int[][] symbolFrequency = nArrayArray;
        int row = 0;
        while (row < 9) {
            int column = 0;
            while (column < 9) {
                if (this.game.isGiven(row, column) || this.game.isFixed(row, column)) {
                    int[] nArray10 = symbolFrequency[this.game.getValue(row, column) - 1];
                    nArray10[0] = nArray10[0] + 1;
                }
                ++column;
            }
            ++row;
        }
        Arrays.sort(symbolFrequency, this.frequencyComparator);
        StringBuffer buffer = new StringBuffer();
        int c = 0;
        while (c < symbolFrequency.length) {
            buffer.append(String.valueOf(symbolFrequency[c][0]) + ":" + symbolFrequency[c][1] + ", ");
            ++c;
        }
        this.rowLabels[5][1] = buffer.toString();
    }

    protected void computeStaticStatistic() {
        int givensCount = 0;
        int[] suggestions = null;
        int[] suggestionsCount = new int[9];
        int[][] nArrayArray = new int[9][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 2;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[2];
        nArray3[1] = 3;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[2];
        nArray4[1] = 4;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[2];
        nArray5[1] = 5;
        nArrayArray[4] = nArray5;
        int[] nArray6 = new int[2];
        nArray6[1] = 6;
        nArrayArray[5] = nArray6;
        int[] nArray7 = new int[2];
        nArray7[1] = 7;
        nArrayArray[6] = nArray7;
        int[] nArray8 = new int[2];
        nArray8[1] = 8;
        nArrayArray[7] = nArray8;
        int[] nArray9 = new int[2];
        nArray9[1] = 9;
        nArrayArray[8] = nArray9;
        int[][] symbolFrequency = nArrayArray;
        int min = 9;
        int row = 0;
        while (row < 9) {
            int column = 0;
            while (column < 9) {
                if (!this.game.isGiven(row, column)) {
                    suggestions = this.game.getSuggestions(row, column);
                    if (suggestions.length < min) {
                        min = suggestions.length;
                    }
                    int n = suggestions.length - 1;
                    suggestionsCount[n] = suggestionsCount[n] + 1;
                } else {
                    ++givensCount;
                    int[] nArray10 = symbolFrequency[this.game.getValue(row, column) - 1];
                    nArray10[0] = nArray10[0] + 1;
                }
                ++column;
            }
            ++row;
        }
        this.rowLabels[1][1] = "" + givensCount;
        this.rowLabels[2][1] = "" + min;
        StringBuffer buffer = new StringBuffer();
        int c = 0;
        while (c < suggestionsCount.length) {
            buffer.append(String.valueOf(c + 1) + ":" + suggestionsCount[c] + ", ");
            ++c;
        }
        this.rowLabels[3][1] = buffer.toString();
        Arrays.sort(symbolFrequency, this.frequencyComparator);
        buffer.setLength(0);
        c = 0;
        while (c < symbolFrequency.length) {
            buffer.append(String.valueOf(symbolFrequency[c][0]) + ":" + symbolFrequency[c][1] + ", ");
            ++c;
        }
        this.rowLabels[4][1] = buffer.toString();
        block0 : switch (min) {
            case 1: {
                switch (suggestionsCount[0]) {
                    case 1: 
                    case 2: {
                        this.rowLabels[0][1] = this.localizeManager.getString("TabStatistic.Severity.3");
                        break block0;
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        this.rowLabels[0][1] = this.localizeManager.getString("TabStatistic.Severity.2");
                        break block0;
                    }
                }
                this.rowLabels[0][1] = this.localizeManager.getString("TabStatistic.Severity.1");
                break;
            }
            case 2: {
                this.rowLabels[0][1] = this.localizeManager.getString("TabStatistic.Severity.4");
                break;
            }
            default: {
                this.rowLabels[0][1] = this.localizeManager.getString("TabStatistic.Severity.5");
            }
        }
    }
}

