/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.soduko.view.tabsupport;

import de.gerdhirsch.soduko.view.OptionsPanel;
import de.gerdhirsch.soduko.view.options.manager.OptionsManager;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelEvent;
import de.gerdhirsch.soduko.view.tabsupport.SupportLevelListener;
import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.io.IOException;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabSupportLevel
extends OptionsPanel
implements ChangeListener,
LocalizeListener {
    public static final int LABELHEIGHT = 20;
    public static final int XPOSLABEL = 25;
    public static final int YPOSLABEL = 15;
    public static final int YPOSSLIDER = 35;
    public static final int SLIDERHEIGHT = 50;
    public static final int COMPONENTWIDTH = 250;
    public static final int YPOSCHECKBOX = 75;
    public static final int YPOSTEXT = 85;
    private LocalizeManager localizeManager = null;
    private OptionsManager optionsManager = null;
    private Component component = null;
    private JSlider supportLevelSlider = null;
    private JLabel sliderLabel = null;
    private JCheckBox possibilityCountCheckBox = null;
    private JEditorPane helpTextSupport = null;
    private JScrollPane helpScroller = null;
    private HashMap<SupportLevelListener, SupportLevelListener> listeners = null;

    public TabSupportLevel(LocalizeManager lm, OptionsManager optionsManager) {
        this.localizeManager = lm;
        this.optionsManager = optionsManager;
        this.localizeManager.addLocalizeListener(this);
        this.createOptionsTab();
    }

    public String getResourceKey() {
        return "TabSupport";
    }

    public int getSupportLevel() {
        return this.supportLevelSlider.getValue();
    }

    public void addSupportLevelListener(SupportLevelListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.put(listener, listener);
    }

    public void removeSupportLevelListener(SupportLevelListener listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void stateChanged(ChangeEvent e) {
        if (!this.supportLevelSlider.getValueIsAdjusting()) {
            this.checkSize();
            this.fireSupportLevelChanged();
        }
    }

    public void localeChanged(EventObject event) {
        this.configureTabSupport();
    }

    protected void fireSupportLevelChanged() {
        SupportLevelEvent event = null;
        int supportLevel = this.supportLevelSlider.getValue();
        boolean showPossibilityCount = this.possibilityCountCheckBox.isSelected();
        if (supportLevel > 2) {
            event = new SupportLevelEvent(this, supportLevel, showPossibilityCount);
            this.possibilityCountCheckBox.setVisible(true);
        } else if (supportLevel == 2) {
            event = new SupportLevelEvent(this, supportLevel, true);
            this.possibilityCountCheckBox.setVisible(false);
        } else {
            event = new SupportLevelEvent(this, supportLevel, false);
            this.possibilityCountCheckBox.setVisible(false);
        }
        if (this.listeners != null) {
            for (SupportLevelListener l : this.listeners.values()) {
                l.supportLevelChanged(event);
            }
        }
    }

    protected void createOptionsTab() {
        Dimension preferredSize = new Dimension(200, 50);
        this.sliderLabel = new JLabel(this.localizeManager.getString("TabSupport.Label"));
        this.sliderLabel.setMaximumSize(preferredSize);
        this.sliderLabel.setMinimumSize(preferredSize);
        int defaultSupportLevel = this.optionsManager.getInteger("Default.Supportlevel");
        this.sliderLabel.setBounds(25, 15, 250, 20);
        this.supportLevelSlider = new JSlider(0, 0, 4, defaultSupportLevel);
        this.supportLevelSlider.setMajorTickSpacing(1);
        this.supportLevelSlider.setMinorTickSpacing(1);
        this.supportLevelSlider.setPaintTicks(true);
        this.supportLevelSlider.setPaintLabels(true);
        this.supportLevelSlider.setSnapToTicks(true);
        this.supportLevelSlider.addChangeListener(this);
        this.supportLevelSlider.setBounds(5, 35, 250, 50);
        this.supportLevelSlider.setOpaque(false);
        this.helpTextSupport = new JEditorPane();
        this.helpScroller = new JScrollPane(this.helpTextSupport);
        this.helpScroller.setVerticalScrollBarPolicy(20);
        this.helpScroller.setHorizontalScrollBarPolicy(30);
        this.helpScroller.setOpaque(false);
        this.helpScroller.setBackground(Color.LIGHT_GRAY);
        this.helpTextSupport.setEditable(false);
        this.helpTextSupport.setOpaque(false);
        this.possibilityCountCheckBox = new JCheckBox();
        this.possibilityCountCheckBox.setOpaque(false);
        this.possibilityCountCheckBox.setVisible(false);
        this.possibilityCountCheckBox.setSelected(true);
        this.possibilityCountCheckBox.addActionListener(new CheckBoxListener());
        this.configureTabSupport();
        this.add((Component)this.sliderLabel, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.supportLevelSlider, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.possibilityCountCheckBox, JLayeredPane.DEFAULT_LAYER);
        this.add((Component)this.helpScroller, JLayeredPane.DEFAULT_LAYER);
    }

    protected void componentResized(ComponentEvent event) {
        this.component = event.getComponent();
        this.checkSize();
    }

    private void checkSize() {
        int width = this.component.getWidth() - 10;
        int height = this.component.getHeight() - 20;
        int boxHeight = this.possibilityCountCheckBox.getHeight() - 10;
        this.possibilityCountCheckBox.setBounds(5, 75, 250, 50);
        if (this.getSupportLevel() < 3) {
            this.helpScroller.setBounds(5, 85, width, height - 85 + 5);
        } else {
            this.helpScroller.setBounds(5, 85 + boxHeight, width, height - (85 + boxHeight) + 5);
        }
        if (width > 250) {
            width = 250;
        }
        this.supportLevelSlider.setBounds(5, 35, width, 50);
    }

    private void configureTabSupport() {
        URL helpURL = this.localizeManager.getResource(this, "/de/gerdhirsch/soduko/view/resources/SupportHelp.html");
        if (helpURL != null) {
            try {
                this.helpTextSupport.setPage(helpURL);
            }
            catch (IOException e) {
                System.err.println("Attempted to read a bad URL: " + helpURL);
                e.printStackTrace();
            }
        } else {
            System.err.println("Resource not found: /de/gerdhirsch/soduko/view/resources/SupportHelp.html");
        }
        this.possibilityCountCheckBox.setText(this.localizeManager.getString("TabSupport.Possibility"));
        this.sliderLabel.setText(this.localizeManager.getString("TabSupport.Label"));
    }

    class CheckBoxListener
    extends AbstractAction {
        CheckBoxListener() {
        }

        public void actionPerformed(ActionEvent event) {
            TabSupportLevel.this.fireSupportLevelChanged();
        }
    }
}

