/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.solver;

import de.gerdhirsch.solver.ColumnNode;
import de.gerdhirsch.solver.Node;
import de.gerdhirsch.solver.Rows2ValuesConverter;
import java.util.List;

class DancingLinksArena {
    ColumnNode firstColumn;
    int rowCount;
    Rows2ValuesConverter converter;
    Node[] solution;
    int initialSolutionIndex;

    DancingLinksArena(int[] labels) {
        ColumnNode[] columns = new ColumnNode[labels.length];
        int i = 0;
        while (i < labels.length) {
            assert (labels[i] > 0);
            columns[i] = new ColumnNode(labels[i]);
            columns[i].setRight(null);
            if (i > 0) {
                columns[i].setLeft(columns[i - 1]);
                columns[i - 1].setRight(columns[i]);
            }
            ++i;
        }
        this.firstColumn = new ColumnNode(0);
        columns[0].setLeft(this.firstColumn);
        this.firstColumn.setRight(columns[0]);
        columns[labels.length - 1].setRight(this.firstColumn);
        this.firstColumn.setLeft(columns[labels.length - 1]);
        this.solution = new Node[labels.length];
        this.initialSolutionIndex = 0;
    }

    ColumnNode getFirstColumn() {
        return (ColumnNode)this.firstColumn.getRight();
    }

    void removeColumn(ColumnNode columnHead) {
        Node scanner = columnHead.getDown();
        while (scanner != columnHead) {
            Node rowTraveller = scanner.getRight();
            while (rowTraveller != scanner) {
                rowTraveller.getUp().setDown(rowTraveller.getDown());
                rowTraveller.getDown().setUp(rowTraveller.getUp());
                rowTraveller.getColumn().decrementSize();
                rowTraveller = rowTraveller.getRight();
            }
            scanner = scanner.getDown();
        }
        columnHead.getLeft().setRight(columnHead.getRight());
        columnHead.getRight().setLeft(columnHead.getLeft());
    }

    void reinsertColumn(ColumnNode columnNode) {
        Node scanner = columnNode.getUp();
        while (scanner != columnNode) {
            Node rowTraveller = scanner.getLeft();
            while (rowTraveller != scanner) {
                rowTraveller.getUp().setDown(rowTraveller);
                rowTraveller.getDown().setUp(rowTraveller);
                rowTraveller.getColumn().incrementSize();
                rowTraveller = rowTraveller.getLeft();
            }
            scanner = scanner.getUp();
        }
        columnNode.getLeft().setRight(columnNode);
        columnNode.getRight().setLeft(columnNode);
    }

    void removeRow(Node rowHead) {
        Node next;
        Node scanner = rowHead;
        do {
            next = scanner.getRight();
            this.removeColumn(scanner.getColumn());
        } while ((scanner = next) != rowHead);
    }

    void reinsertRow(Node rowHead) {
        Node scanner = rowHead;
        do {
            scanner = scanner.getLeft();
            this.reinsertColumn(scanner.getColumn());
        } while (scanner != rowHead);
    }

    Node addInitialRow(int[] labels) {
        Node result = null;
        if (labels.length != 0) {
            Node prev = null;
            Node first = null;
            boolean found = false;
            ++this.rowCount;
            int i = 0;
            while (i < labels.length) {
                Node node = new Node(this.rowCount, labels[i]);
                assert (labels[i] > 0);
                node.setLeft(prev);
                node.setRight(null);
                if (prev != null) {
                    prev.setRight(node);
                } else {
                    first = node;
                }
                ColumnNode searcher = this.firstColumn;
                do {
                    if (searcher.getLabel() != labels[i]) continue;
                    node.setColumn(searcher);
                    searcher.addAtEnd(node);
                    found = true;
                } while ((searcher = (ColumnNode)searcher.getRight()) != this.firstColumn);
                if (!found) {
                    System.out.println("Can't find header for " + searcher.getLabel());
                    assert (found);
                }
                prev = node;
                ++i;
            }
            first.setLeft(prev);
            prev.setRight(first);
            result = first;
        }
        return result;
    }

    void solveRecurse(int solutionIndex) {
        ColumnNode nextColumn = (ColumnNode)this.firstColumn.getRight();
        if (nextColumn != this.firstColumn) {
            Node row = nextColumn.getDown();
            while (row != nextColumn) {
                this.removeRow(row);
                this.solution[solutionIndex] = row;
                this.solveRecurse(solutionIndex + 1);
                this.reinsertRow(row);
                row = row.getDown();
            }
        } else {
            int[] solutionRowNumbers = new int[solutionIndex];
            int i = 0;
            while (i < solutionIndex) {
                solutionRowNumbers[i] = this.solution[i].getRowNumber() - 1;
                ++i;
            }
            this.converter.convert(solutionRowNumbers, null);
        }
    }

    void solve(Rows2ValuesConverter handler) {
        this.converter = handler;
        this.solveRecurse(this.initialSolutionIndex);
    }

    void removeInitialSolutionSet(List solutions) {
        for (Node row : solutions) {
            this.removeRow(row);
            this.solution[this.initialSolutionIndex++] = row;
        }
    }
}

