/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.solver;

import de.gerdhirsch.solver.Converter;
import de.gerdhirsch.solver.DancingLinksArena;
import de.gerdhirsch.solver.Node;
import de.gerdhirsch.solver.SudokuSolutionHandler;
import java.util.ArrayList;

public class DancingLinksSudoku {
    DancingLinksArena dla;
    SudokuSolutionHandler sudokuSolutionHandler;

    public DancingLinksSudoku(int[][] puzzle, SudokuSolutionHandler handler) {
        ArrayList<Node> givenList = new ArrayList<Node>();
        int[] labels = new int[324];
        int i = 0;
        while (i < 324) {
            labels[i] = i + 1;
            ++i;
        }
        this.dla = new DancingLinksArena(labels);
        int[] rowData = new int[4];
        int row = 0;
        while (row < 9) {
            int column = 0;
            while (column < 9) {
                int digit = 0;
                while (digit < 9) {
                    boolean isGiven = puzzle[row][column] == digit + 1;
                    rowData[0] = 1 + (row * 9 + column);
                    rowData[1] = 82 + (row * 9 + digit);
                    rowData[2] = 163 + (column * 9 + digit);
                    int boxrow = row / 3;
                    int boxcol = column / 3;
                    rowData[3] = 244 + ((boxrow * 3 + boxcol) * 9 + digit);
                    Node newRow = this.dla.addInitialRow(rowData);
                    if (isGiven) {
                        givenList.add(newRow);
                    }
                    ++digit;
                }
                ++column;
            }
            ++row;
        }
        this.dla.removeInitialSolutionSet(givenList);
        this.sudokuSolutionHandler = handler;
    }

    public void solveit() {
        this.dla.solve(new Converter(this));
    }
}

