/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.solver;

import de.gerdhirsch.solver.ColumnNode;
import de.gerdhirsch.solver.DancingLinksArena;
import de.gerdhirsch.solver.Node;

public class DlinksTest {
    void verifyOriginal(DancingLinksArena dla) {
        ColumnNode column = dla.getFirstColumn();
        assert (column != null);
        assert (column.getRowNumber() == 0);
        assert (column.getLabel() == 1);
        assert (column.getCount() == 2);
        assert (column.getDown().verifyRowAndLabel(1, 1));
        assert (column.getRight().verifyRowAndLabel(0, 2));
        assert (column.getLeft().verifyRowAndLabel(0, 0));
        assert (column.getUp().verifyRowAndLabel(4, 1));
        assert (column.getColumn() == null);
        Node testNode = column.getDown();
        assert (testNode != null);
        assert (testNode.getRowNumber() == 1);
        assert (testNode.getLabel() == 1);
        assert (testNode.getLeft().verifyRowAndLabel(1, 2));
        assert (testNode.getUp() == column);
        assert (testNode.getDown().verifyRowAndLabel(4, 1));
        assert (testNode.getColumn() == column);
        assert (testNode.getRight().verifyRowAndLabel(1, 2));
        Node prev = testNode;
        testNode = testNode.getDown();
        assert (testNode.getUp() == prev);
        assert (testNode.getRowNumber() == 4);
        assert (testNode.getLabel() == 1);
        assert (testNode.getLeft().verifyRowAndLabel(4, 4));
        assert (testNode.getDown() == column);
        assert (testNode.getColumn() == column);
        assert (testNode.getRight().verifyRowAndLabel(4, 4));
        column = (ColumnNode)column.getRight();
        assert (column != null);
        assert (column.getRowNumber() == 0);
        assert (column.getLabel() == 2);
        assert (column.getCount() == 2);
        assert (column.getLeft().verifyRowAndLabel(0, 1));
        assert (column.getRight().verifyRowAndLabel(0, 3));
        assert (column.getDown().verifyRowAndLabel(1, 2));
        assert (column.getUp().verifyRowAndLabel(2, 2));
        assert (column.getColumn() == null);
        testNode = column.getDown();
        assert (testNode != null);
        assert (testNode.getRowNumber() == 1);
        assert (testNode.getLabel() == 2);
        assert (testNode.getLeft().verifyRowAndLabel(1, 1));
        assert (testNode.getRight().verifyRowAndLabel(1, 1));
        assert (testNode.getUp() == column);
        assert (testNode.getColumn() == column);
        prev = testNode;
        testNode = testNode.getDown();
        assert (testNode.getUp() == prev);
        assert (testNode.getRowNumber() == 2);
        assert (testNode.getLabel() == 2);
        assert (testNode.getLeft().verifyRowAndLabel(2, 4));
        assert (testNode.getDown() == column);
        assert (testNode.getColumn() == column);
        assert (testNode.getRight().verifyRowAndLabel(2, 3));
        column = (ColumnNode)column.getRight();
        assert (column != null);
        assert (column.getRowNumber() == 0);
        assert (column.getLabel() == 3);
        assert (column.getCount() == 2);
        assert (column.getLeft().verifyRowAndLabel(0, 2));
        assert (column.getRight().verifyRowAndLabel(0, 4));
        assert (column.getDown().verifyRowAndLabel(2, 3));
        assert (column.getUp().verifyRowAndLabel(3, 3));
        assert (column.getColumn() == null);
        testNode = column.getDown();
        assert (testNode != null);
        assert (testNode.getRowNumber() == 2);
        assert (testNode.getLabel() == 3);
        assert (testNode.getLeft().verifyRowAndLabel(2, 2));
        assert (testNode.getRight().verifyRowAndLabel(2, 4));
        assert (testNode.getDown().verifyRowAndLabel(3, 3));
        assert (testNode.getUp() == column);
        assert (testNode.getColumn() == column);
        prev = testNode;
        testNode = testNode.getDown();
        assert (testNode.getUp() == prev);
        assert (testNode.getRowNumber() == 3);
        assert (testNode.getLabel() == 3);
        assert (testNode.getLeft().verifyRowAndLabel(3, 4));
        assert (testNode.getRight().verifyRowAndLabel(3, 4));
        assert (testNode.getDown() == column);
        assert (testNode.getUp().verifyRowAndLabel(2, 3));
        assert (testNode.getColumn() == column);
        column = (ColumnNode)column.getRight();
        assert (column != null);
        assert (column.getRowNumber() == 0);
        assert (column.getLabel() == 4);
        assert (column.getCount() == 3);
        assert (column.getLeft().verifyRowAndLabel(0, 3));
        assert (column.getRight().verifyRowAndLabel(0, 0));
        assert (column.getDown().verifyRowAndLabel(2, 4));
        assert (column.getUp().verifyRowAndLabel(4, 4));
        assert (column.getColumn() == null);
        testNode = column.getDown();
        assert (testNode != null);
        assert (testNode.getRowNumber() == 2);
        assert (testNode.getLabel() == 4);
        assert (testNode.getLeft().verifyRowAndLabel(2, 3));
        assert (testNode.getRight().verifyRowAndLabel(2, 2));
        assert (testNode.getDown().verifyRowAndLabel(3, 4));
        assert (testNode.getUp() == column);
        assert (testNode.getColumn() == column);
        prev = testNode;
        testNode = testNode.getDown();
        assert (testNode.getUp() == prev);
        assert (testNode.getRowNumber() == 3);
        assert (testNode.getLabel() == 4);
        assert (testNode.getLeft().verifyRowAndLabel(3, 3));
        assert (testNode.getRight().verifyRowAndLabel(3, 3));
        assert (testNode.getDown().verifyRowAndLabel(4, 4));
        assert (testNode.getUp().verifyRowAndLabel(2, 4));
        assert (testNode.getColumn() == column);
        prev = testNode;
        testNode = testNode.getDown();
        assert (testNode.getUp() == prev);
        assert (testNode.getRowNumber() == 4);
        assert (testNode.getLabel() == 4);
        assert (testNode.getLeft().verifyRowAndLabel(4, 1));
        assert (testNode.getRight().verifyRowAndLabel(4, 1));
        assert (testNode.getDown() == column);
        assert (testNode.getUp().verifyRowAndLabel(3, 4));
        assert (testNode.getColumn() == column);
    }

    void testit() {
        int[] labels = new int[]{1, 2, 3, 4};
        int[] row1 = new int[]{1, 2};
        int[] row2 = new int[]{2, 3, 4};
        int[] row3 = new int[]{3, 4};
        int[] row4 = new int[]{1, 4};
        DancingLinksArena dla = new DancingLinksArena(labels);
        dla.addInitialRow(row1);
        dla.addInitialRow(row2);
        dla.addInitialRow(row3);
        dla.addInitialRow(row4);
        this.verifyOriginal(dla);
        Node firstRow = dla.getFirstColumn().getDown();
        dla.removeRow(firstRow);
        ColumnNode columnNode = dla.getFirstColumn();
        assert (columnNode.getCount() == 1);
        assert (columnNode.getRowNumber() == 0);
        assert (columnNode.getLabel() == 3);
        assert (columnNode.getLeft().verifyRowAndLabel(0, 0));
        assert (columnNode.getRight().verifyRowAndLabel(0, 4));
        assert (columnNode.getDown().verifyRowAndLabel(3, 3));
        assert (columnNode.getUp().verifyRowAndLabel(3, 3));
        assert (firstRow.verifyRowAndLabel(1, 1));
        assert (firstRow.getLeft().verifyRowAndLabel(1, 2));
        assert (firstRow.getRight().verifyRowAndLabel(1, 2));
        assert (firstRow.getDown().verifyRowAndLabel(4, 1));
        assert (firstRow.getUp().verifyRowAndLabel(0, 1));
        dla.reinsertRow(firstRow);
        this.verifyOriginal(dla);
    }

    public static void main(String[] args) {
        DlinksTest dl = new DlinksTest();
        dl.testit();
        System.out.println("DlinksTest unit test passed!");
    }
}

