/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.solver;

import de.gerdhirsch.solver.ColumnNode;

class Node {
    Node left;
    Node right;
    Node up;
    Node down;
    ColumnNode column;
    int rowNumber;
    int label;

    public String labelOrNull(Node node) {
        if (node == null) {
            return "NULL";
        }
        return node.getFullLabel();
    }

    public String getFullLabel() {
        return "row " + this.rowNumber + ", label " + this.label;
    }

    public String toString() {
        return "Node " + this.getFullLabel() + ", left is (" + this.labelOrNull(this.getLeft()) + "), right is (" + this.labelOrNull(this.getRight()) + "), down is (" + this.labelOrNull(this.getDown()) + "), up is (" + this.labelOrNull(this.getUp()) + "), column is (" + this.labelOrNull(this.getColumn()) + ")";
    }

    void setLeft(Node node) {
        this.left = node;
    }

    Node getLeft() {
        return this.left;
    }

    void setRight(Node node) {
        this.right = node;
    }

    Node getRight() {
        return this.right;
    }

    void setUp(Node node) {
        this.up = node;
    }

    Node getUp() {
        return this.up;
    }

    void setDown(Node node) {
        this.down = node;
    }

    Node getDown() {
        return this.down;
    }

    void setColumn(ColumnNode node) {
        this.column = node;
    }

    ColumnNode getColumn() {
        return this.column;
    }

    int getLabel() {
        return this.label;
    }

    int getRowNumber() {
        return this.rowNumber;
    }

    boolean verifyRowAndLabel(int row, int label) {
        return this.getRowNumber() == row && this.getLabel() == label;
    }

    Node(int rowNumber, int label) {
        this.setLeft(this);
        this.setRight(this);
        this.setUp(this);
        this.setDown(this);
        this.rowNumber = rowNumber;
        this.label = label;
    }
}

