/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.util.jar;

import de.gerdhirsch.util.resources.LocalizeManagerImpl;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class BrowserControl {
    private static final String WIN_ID = "Windows";
    private static final String WIN_PATH = "rundll32";
    private static final String WIN_FLAG = "url.dll,FileProtocolHandler";
    private static final String UNIX_PATH = "netscape";
    private static final String UNIX_FLAG = "-remote openURL";

    public static void main(String[] args) throws MalformedURLException {
        BrowserControl bc = new BrowserControl();
        bc.doIt();
    }

    private void doIt() throws MalformedURLException {
        LocalizeManagerImpl localizeManager = new LocalizeManagerImpl("de.gerdhirsch.soduko.view.resources.Resource");
        String url = "/de/gerdhirsch/soduko/view/resources/KillerSodukoHelp.html";
        URL helpURL = localizeManager.getResource(this, url);
        URL webURL = new URL("http://www.gerdhirsch.de/");
        System.out.println();
        System.out.println("locale Seite:" + helpURL);
        BrowserControl.displayURL(helpURL.toString());
    }

    public static void displayURL(String url) {
        block6: {
            boolean windows = BrowserControl.isWindowsPlatform();
            String cmd = null;
            try {
                if (windows) {
                    cmd = "rundll32 url.dll,FileProtocolHandler " + url;
                    Process p = Runtime.getRuntime().exec(cmd);
                    break block6;
                }
                cmd = "netscape -remote openURL(" + url + ")";
                Process p = Runtime.getRuntime().exec(cmd);
                try {
                    int exitCode = p.waitFor();
                    if (exitCode != 0) {
                        cmd = "netscape " + url;
                        p = Runtime.getRuntime().exec(cmd);
                    }
                }
                catch (InterruptedException x) {
                    System.err.println("Error bringing up browser, cmd='" + cmd + "'");
                    System.err.println("Caught: " + x);
                }
            }
            catch (IOException x) {
                System.err.println("Could not invoke browser, command=" + cmd);
                System.err.println("Caught: " + x);
            }
        }
    }

    public static boolean isWindowsPlatform() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith(WIN_ID);
    }
}

