/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.util.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarURLConverter {
    public static URL getBrowsableURL(URL url, Object loader) throws IOException {
        URL retVal = null;
        File target = null;
        String baseDir = null;
        URL jarDirURL = null;
        if (!url.toString().contains("jar!")) {
            return url;
        }
        baseDir = JarURLConverter.getTempDir();
        String subDir = null;
        String subDirName = null;
        String entryName = null;
        JarURLConnection connection = (JarURLConnection)url.openConnection();
        JarEntry entry = connection.getJarEntry();
        entryName = entry.getName();
        int posLastSlash = entryName.lastIndexOf(47);
        subDir = entryName.substring(0, posLastSlash);
        entryName = entryName.substring(posLastSlash + 1);
        posLastSlash = subDir.lastIndexOf("/");
        jarDirURL = loader.getClass().getResource(String.valueOf('/') + subDir);
        subDirName = subDir.substring(posLastSlash + 1);
        subDir = subDir.substring(0, posLastSlash);
        if (jarDirURL == null) {
            throw new IOException("Directory not found: /" + subDir);
        }
        subDir = subDir.replace('/', File.separatorChar);
        String targetPath = String.valueOf(baseDir) + File.separatorChar + subDir;
        target = new File(targetPath);
        if (!target.exists() && !target.mkdirs()) {
            System.err.println("cannot create " + targetPath + " set to " + baseDir);
            target = new File(baseDir);
        }
        JarURLConverter.copyArchivDirectory(jarDirURL, target);
        String indexPath = "file:///" + target.getAbsolutePath() + File.separatorChar + subDirName + File.separatorChar + entryName;
        try {
            retVal = new URL(indexPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static void copyArchivDirectory(URL source, File target) {
        if (target == null || !target.isDirectory()) {
            throw new IllegalArgumentException("Target must be a directory: " + target);
        }
        JarFile jarFile = null;
        JarEntry jarEntry = null;
        String jarEntryName = null;
        String targetPath = target.getAbsolutePath();
        String resource = source.toString();
        int posFirstSlash = resource.indexOf(47) + 1;
        String inputFileName = resource.substring(posFirstSlash);
        int posJar = inputFileName.indexOf("!");
        String jarFileName = inputFileName.substring(0, posJar);
        String jarDirectory = String.valueOf(inputFileName.substring(posJar + 2)) + "/";
        try {
            System.out.println("try new JarFile(" + jarFileName + ")");
            jarFile = new JarFile(jarFileName);
            jarEntry = jarFile.getJarEntry(jarDirectory);
            if (jarEntry == null) {
                throw new IllegalArgumentException("Entry doesn\u00b4t exists! directory: " + resource);
            }
            if (!jarEntry.isDirectory()) {
                throw new IllegalArgumentException("Source must be a directory: " + resource);
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                jarEntry = entries.nextElement();
                jarEntryName = jarEntry.getName();
                if (!jarEntryName.contains(jarDirectory)) continue;
                if (jarEntry.isDirectory()) {
                    String dirName = JarURLConverter.createDirName(targetPath, jarEntryName, jarDirectory);
                    File dir = new File(dirName);
                    if (!dir.exists()) {
                        dir.mkdirs();
                        continue;
                    }
                    if (!dir.exists() || dir.isDirectory()) continue;
                    throw new IOException("Cannot create directory: " + dirName);
                }
                String fileName = JarURLConverter.createFileName(targetPath, jarEntryName, jarDirectory);
                JarURLConverter.copyFile(jarFile, jarEntry, fileName);
            }
        }
        catch (IOException e) {
            System.out.println("IOException caught: " + jarFileName);
            e.printStackTrace();
        }
    }

    public static String createDirName(String targetPath, String jarEntryName, String jarDirectory) {
        String retVal = null;
        int posLastSlash = jarDirectory.substring(0, jarDirectory.length() - 1).lastIndexOf("/");
        String subDirName = jarEntryName.substring(posLastSlash + 1, jarEntryName.length() - 1);
        subDirName = subDirName.replace('/', File.separatorChar);
        retVal = String.valueOf(targetPath) + File.separatorChar + subDirName;
        return retVal;
    }

    public static String createFileName(String targetPath, String jarEntryName, String jarDirectory) {
        String retVal = null;
        int posLastSlash = jarEntryName.lastIndexOf("/");
        String subDirName = JarURLConverter.createDirName(targetPath, jarEntryName.substring(0, posLastSlash + 1), jarDirectory);
        String fileName = jarEntryName.substring(posLastSlash + 1);
        retVal = String.valueOf(subDirName) + File.separatorChar + fileName;
        return retVal;
    }

    public static void copyFile(JarFile jarFile, JarEntry jarEntry, String fileName) {
        FileOutputStream out = null;
        BufferedOutputStream bufferedOut = null;
        InputStream in = null;
        BufferedInputStream bufferedIn = null;
        try {
            out = new FileOutputStream(fileName);
            bufferedOut = new BufferedOutputStream(out);
            in = jarFile.getInputStream(jarEntry);
            bufferedIn = new BufferedInputStream(in);
            int c = 0;
            while ((c = bufferedIn.read()) != -1) {
                bufferedOut.write(c);
            }
            bufferedOut.flush();
            bufferedOut.close();
            bufferedIn.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getTempDir() {
        String tempDir = System.getProperty("user.home");
        try {
            File tempFile = File.createTempFile("Sodukohelp", "tmp");
            tempFile.deleteOnExit();
            String tempFileName = tempFile.getAbsolutePath();
            int posLastSlash = tempFileName.lastIndexOf(File.separatorChar);
            tempDir = tempFileName.substring(0, posLastSlash);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tempDir;
    }
}

