/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.util.resources;

import de.gerdhirsch.util.resources.LocalizeListener;
import de.gerdhirsch.util.resources.LocalizeManager;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizeManagerImpl
implements LocalizeManager {
    private ResourceBundle resourceBundle = null;
    private Locale locale = null;
    private String baseName = null;
    private EventObject eventObject = null;
    private HashMap<LocalizeListener, LocalizeListener> listeners = null;
    private Locale[] locales = null;

    public LocalizeManagerImpl(String baseName) {
        this.baseName = baseName;
        this.eventObject = new EventObject(this);
        this.locale = Locale.getDefault();
        this.resourceBundle = ResourceBundle.getBundle(this.baseName, this.locale);
    }

    @Override
    public void setLocale(Locale locale) {
        if (!this.locale.equals(locale)) {
            this.locale = locale;
            this.resourceBundle = ResourceBundle.getBundle(this.baseName, this.locale);
            this.fireLocaleChanged(this.eventObject);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocales(Locale[] locales) {
        this.locales = locales;
    }

    @Override
    public Locale[] getLocales() {
        if (this.locales == null) {
            ArrayList<Locale> retVal = new ArrayList<Locale>();
            retVal.add(Locale.GERMANY);
            retVal.add(Locale.ENGLISH);
            this.locales = retVal.toArray(new Locale[retVal.size()]);
        }
        return this.locales;
    }

    @Override
    public Object getObject(String key) {
        return this.resourceBundle.getObject(key);
    }

    @Override
    public String getString(String key) {
        return this.resourceBundle.getString(key);
    }

    @Override
    public HashMap<String, Object> loadKey(Object target, String key, String valueSeparator, String keySeparator, String mnemonicSign) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String resourceString = this.getString(key);
        if (resourceString == null || resourceString.length() == 0) {
            return map;
        }
        Icon icon = null;
        char mnemonic = '\u0000';
        KeyStroke keyStroke = null;
        map.clear();
        StringTokenizer st = new StringTokenizer(resourceString.trim(), valueSeparator);
        String token = null;
        String[] keyValue = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken().trim();
            keyValue = token.split(keySeparator);
            if (keyValue.length == 2) {
                map.put(keyValue[0], keyValue[1]);
                continue;
            }
            throw new IllegalArgumentException("wrong token: " + token);
        }
        String temp = null;
        temp = (String)map.get("SmallIcon");
        if (temp != null && target != null) {
            icon = LocalizeManagerImpl.loadIcon(target.getClass(), temp);
            map.put("SmallIcon", icon);
        }
        String ALT = "Alt";
        String CTRL = "Ctrl";
        String STRG = "Strg";
        String SHIFT = "Shift";
        int modifier = 0;
        temp = (String)map.get("AcceleratorKey");
        if (temp != null) {
            char accelerator = temp.charAt(0);
            StringTokenizer modifiers = new StringTokenizer(temp, ",");
            String modifierToken = null;
            while (modifiers.hasMoreTokens()) {
                modifierToken = modifiers.nextToken().trim();
                if (ALT.equalsIgnoreCase(modifierToken)) {
                    modifier |= 0x200;
                    continue;
                }
                if (CTRL.equalsIgnoreCase(modifierToken) || STRG.equalsIgnoreCase(modifierToken)) {
                    modifier |= 0x80;
                    continue;
                }
                if (!SHIFT.equalsIgnoreCase(modifierToken)) continue;
                modifier |= 0x40;
            }
            keyStroke = KeyStroke.getKeyStroke((int)accelerator, modifier);
            map.put("AcceleratorKey", keyStroke);
        }
        if ((temp = (String)map.get("Name")) != null && mnemonicSign != null && temp.contains(mnemonicSign)) {
            int pos = temp.indexOf(mnemonicSign.charAt(0));
            mnemonic = temp.charAt(pos + 1);
            String name = temp.substring(0, pos);
            name = String.valueOf(name) + temp.substring(pos + 1);
            map.put("Name", name);
            map.put("MnemonicKey", mnemonic);
        }
        return map;
    }

    @Override
    public URL getResource(Object target, String resource) {
        String[] resourceNames;
        URL retVal = null;
        Class<?> loader = target.getClass();
        String name = resource.substring(0, resource.lastIndexOf("."));
        String ext = resource.substring(resource.lastIndexOf("."));
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        String variant = this.locale.getVariant();
        String name_Language_Country_Variant = null;
        String name_Language_Country = null;
        String name_Language = null;
        if (country != null && variant != null) {
            name_Language_Country_Variant = String.valueOf(name) + "_" + language + "_" + country + "_" + variant + ext;
        }
        if (country != null) {
            name_Language_Country = String.valueOf(name) + "_" + language + "_" + country + ext;
        }
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        name_Language = String.valueOf(name) + "_" + language + ext;
        String[] stringArray = resourceNames = new String[]{name_Language_Country_Variant, name_Language_Country, name_Language, resource};
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String res = stringArray[n];
            if (res != null && (retVal = loader.getResource(res)) != null) break;
            ++n;
        }
        return retVal;
    }

    public InputStream getResourceAsStream(Object target, String resource) {
        String[] resourceNames;
        InputStream retVal = null;
        Class<?> loader = target.getClass();
        String name = resource.substring(0, resource.lastIndexOf("."));
        String ext = resource.substring(resource.lastIndexOf("."));
        String language = this.locale.getLanguage();
        String country = this.locale.getCountry();
        String variant = this.locale.getVariant();
        String name_Language_Country_Variant = null;
        String name_Language_Country = null;
        String name_Language = null;
        if (country != null && variant != null) {
            name_Language_Country_Variant = String.valueOf(name) + "_" + language + "_" + country + "_" + variant + ext;
        }
        if (country != null) {
            name_Language_Country = String.valueOf(name) + "_" + language + "_" + country + ext;
        }
        if (language == null) {
            language = Locale.getDefault().getLanguage();
        }
        name_Language = String.valueOf(name) + "_" + language + ext;
        String[] stringArray = resourceNames = new String[]{name_Language_Country_Variant, name_Language_Country, name_Language, resource};
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String res = stringArray[n];
            if (res != null && (retVal = loader.getResourceAsStream(res)) != null) break;
            ++n;
        }
        return retVal;
    }

    public static Icon loadIcon(Class targetClass, String iconName) {
        ImageIcon retVal = null;
        if (iconName != null) {
            try {
                URL iconURL = targetClass.getResource(iconName);
                if (iconURL == null) {
                    System.err.println("LocalizeManager: Icon not found:" + iconName);
                } else {
                    retVal = new ImageIcon(iconURL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    @Override
    public void addLocalizeListener(LocalizeListener listener) {
        if (this.listeners == null) {
            this.listeners = new HashMap();
        }
        this.listeners.put(listener, listener);
    }

    @Override
    public void removeLocalizeListener(LocalizeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    protected void fireLocaleChanged(EventObject event) {
        if (this.listeners == null) {
            return;
        }
        Iterator<LocalizeListener> it = this.listeners.values().iterator();
        while (it.hasNext()) {
            it.next().localeChanged(event);
        }
    }
}

