/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.util.resources;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflexionActionListener
extends AbstractAction {
    public static final String METHOD = "Method";
    public static final String TARGET = "Target";
    public static final String RESOURCE_KEY = "ResourceKey";
    static /* synthetic */ Class class$0;

    public ReflexionActionListener(Object target, Method actionPerformedMethod, String resourceKey) {
        if (target == null || actionPerformedMethod == null) {
            throw new IllegalArgumentException("target and Object must not be null");
        }
        this.putValue(TARGET, target);
        this.putValue(METHOD, actionPerformedMethod);
        this.putValue(RESOURCE_KEY, resourceKey);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        try {
            Method method = (Method)this.getValue(METHOD);
            Object target = this.getValue(TARGET);
            method.invoke(target, event);
        }
        catch (IllegalArgumentException e1) {
            e1.printStackTrace();
        }
        catch (IllegalAccessException e1) {
            e1.printStackTrace();
        }
        catch (InvocationTargetException e1) {
            e1.printStackTrace();
        }
    }

    public static ReflexionActionListener createAction(Object target, String methodName, String key) {
        ReflexionActionListener retVal = null;
        Method method = ReflexionActionListener.getMethod(target, methodName);
        retVal = new ReflexionActionListener(target, method, key);
        return retVal;
    }

    public static void configureAction(AbstractAction action, HashMap<String, Object> map) {
        if (map != null && !map.isEmpty()) {
            ReflexionActionListener.configureAction(action, (String)map.get("Name"), (Icon)map.get("SmallIcon"), (KeyStroke)map.get("AcceleratorKey"), (Integer)map.get("MnemonicKey"), (String)map.get("ShortDescription"), (String)map.get("ActionCommandKey"), (String)map.get("LongDescription"));
        }
    }

    public static void configureAction(AbstractAction action, String name, Icon icon, KeyStroke keyStroke, Integer mnemonicKey, String shortDescription, String actionCommand, String longDescription) {
        action.putValue("Name", name);
        action.putValue("SmallIcon", icon);
        action.putValue("AcceleratorKey", keyStroke);
        action.putValue("MnemonicKey", mnemonicKey);
        action.putValue("ShortDescription", shortDescription);
        action.putValue("ActionCommandKey", actionCommand);
        action.putValue("LongDescription", longDescription);
    }

    private static Method getMethod(Object target, String methodName) {
        Method retVal = null;
        try {
            Class<?> targetClass = target.getClass();
            retVal = targetClass.getDeclaredMethod(methodName, ActionEvent.class);
            retVal.setAccessible(true);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static Icon loadIcon(Class targetClass, String iconName) {
        ImageIcon retVal = null;
        if (iconName != null) {
            try {
                URL iconURL = targetClass.getResource(iconName);
                if (iconURL == null) {
                    System.err.println("Icon not found:" + iconName);
                } else {
                    retVal = new ImageIcon(iconURL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return retVal;
    }
}

