/*
 * Decompiled with CFR 0.152.
 */
package de.gerdhirsch.util.undoredo;

import de.gerdhirsch.util.undoredo.Command;
import de.gerdhirsch.util.undoredo.UndoRedoHandler;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UndoRedoHandlerImpl
implements UndoRedoHandler,
Cloneable {
    Stack<Command> undoStack = new Stack();
    Stack<Command> redoStack = new Stack();
    int modifiedCount = 0;

    @Override
    public boolean isRedoable() {
        return !this.redoStack.isEmpty();
    }

    @Override
    public boolean isUndoable() {
        return !this.undoStack.isEmpty();
    }

    @Override
    public boolean isModified() {
        return this.modifiedCount != 0;
    }

    @Override
    public synchronized void undo() throws Exception {
        Command c = this.undoStack.pop();
        --this.modifiedCount;
        this.redoStack.push(c);
        c.undo();
    }

    @Override
    public synchronized void redo() throws Exception {
        Command c = this.redoStack.pop();
        ++this.modifiedCount;
        this.undoStack.push(c);
        c.doIt();
    }

    @Override
    public synchronized void doIt(Command c) throws Exception {
        if (this.modifiedCount < 0) {
            this.modifiedCount = this.undoStack.size() + 1;
        }
        ++this.modifiedCount;
        this.undoStack.push(c);
        this.redoStack.clear();
        c.doIt();
    }

    @Override
    public void resetModified() {
        this.modifiedCount = 0;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        UndoRedoHandlerImpl retVal = (UndoRedoHandlerImpl)super.clone();
        retVal.redoStack = this.deepCopy(this.redoStack);
        retVal.undoStack = this.deepCopy(this.undoStack);
        assert (this.redoStack.isEmpty() == retVal.redoStack.isEmpty());
        assert (this.undoStack.isEmpty() == retVal.undoStack.isEmpty());
        return retVal;
    }

    private Stack<Command> deepCopy(Stack<Command> stack) throws CloneNotSupportedException {
        Stack<Command> retVal = new Stack<Command>();
        Object[] commands = new Command[stack.size()];
        stack.copyInto(commands);
        int i = 0;
        while (i < commands.length) {
            retVal.push((Command)commands[i].clone());
            ++i;
        }
        return retVal;
    }
}

